/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.DbUtil;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.db.ds.DSWrapper;
import org.dromara.hutool.db.ds.DbConfig;
import org.dromara.hutool.log.LogUtil;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class DSPool
implements Closeable {
    private static final String CONNECTION_PREFIX = "connection.";
    private final Setting setting;
    private final Map<String, DSWrapper> pool;
    private DSFactory factory;

    public static DSPool getInstance() {
        return Singleton.get(DSPool.class.getName(), DSPool::new);
    }

    public DSPool() {
        this(null);
    }

    public DSPool(Setting setting) {
        this(setting, null);
    }

    public DSPool(Setting setting, DSFactory factory) {
        this.setting = null != setting ? setting : GlobalDbConfig.createDbSetting();
        DbUtil.setShowSqlGlobal(this.setting);
        this.factory = null != factory ? factory : SpiUtil.loadFirstAvailable(DSFactory.class);
        this.pool = new SafeConcurrentHashMap<String, DSWrapper>();
    }

    public Setting getSetting() {
        return this.setting;
    }

    public String getDataSourceName() {
        return this.factory.getDataSourceName();
    }

    public DSPool setFactory(DSFactory factory) {
        this.factory = factory;
        LogUtil.debug("Custom use [{}] DataSource.", factory.getDataSourceName());
        return this;
    }

    public DataSource getDataSource(String group) {
        if (group == null) {
            group = "";
        }
        return this.pool.computeIfAbsent(group, this::createDSWrapper);
    }

    public DSPool closeDataSource(String group) {
        DSWrapper removed;
        if (group == null) {
            group = "";
        }
        if (null != (removed = this.pool.remove(group))) {
            IoUtil.closeQuietly(removed);
        }
        return this;
    }

    @Override
    public void close() {
        Map<String, DSWrapper> pool = this.pool;
        if (MapUtil.isNotEmpty(pool)) {
            Collection<DSWrapper> values = pool.values();
            pool.clear();
            for (DSWrapper ds : values) {
                ds.close();
            }
        }
    }

    private DSWrapper createDSWrapper(String group) {
        Setting subSetting;
        if (group == null) {
            group = "";
        }
        if (MapUtil.isEmpty(subSetting = this.setting.getSetting(group))) {
            throw new DbRuntimeException("No config for group: [{}]", group);
        }
        DbConfig dbConfig = DSPool.toDbConfig(subSetting);
        return DSWrapper.wrap(this.factory.createDataSource(dbConfig), dbConfig.getDriver());
    }

    private static DbConfig toDbConfig(Setting setting) {
        String url = setting.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL!");
        }
        DSPool.removeShowSqlParams(setting);
        String driver = setting.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank(driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        DbConfig dbConfig = DbConfig.of().setUrl(url).setDriver(driver).setUser(setting.getAndRemove(DSKeys.KEY_ALIAS_USER)).setPass(setting.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD));
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = setting.getAndRemove(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        Props connProps = new Props();
        Set<String> keys = setting.keySet();
        for (String key : keys) {
            if (!key.startsWith(CONNECTION_PREFIX)) continue;
            connProps.set(StrUtil.subSuf(key, CONNECTION_PREFIX.length()), setting.remove(key));
        }
        dbConfig.setConnProps(connProps);
        dbConfig.setPoolProps(setting.toProps());
        return dbConfig;
    }

    private static void removeShowSqlParams(Setting setting) {
        setting.remove("showSql");
        setting.remove("formatSql");
        setting.remove("showParams");
        setting.remove("sqlLevel");
    }
}

