/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSPool;
import org.dromara.hutool.log.LogUtil;

public class DSUtil {
    public static DataSource getJndiDSWithLog(String jndiName) {
        try {
            return DSUtil.getJndiDS(jndiName);
        }
        catch (DbRuntimeException e) {
            LogUtil.error(e.getCause(), "Find JNDI datasource error!", new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDS(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static DataSource getDS() {
        return DSUtil.getDS(null);
    }

    public static DataSource getDS(String group) {
        return DSPool.getInstance().getDataSource(group);
    }

    public static DSFactory setGlobalDSFactory(DSFactory dsFactory) {
        DSPool.getInstance().setFactory(dsFactory);
        return dsFactory;
    }
}

