/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.util.Properties;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.driver.DriverUtil;

public class DbConfig {
    private String driver;
    private String url;
    private String user;
    private String pass;
    private Properties connProps;
    private Properties poolProps;

    public static DbConfig of() {
        return new DbConfig();
    }

    public DbConfig() {
    }

    public DbConfig(String url, String user, String pass) {
        this.init(url, user, pass);
    }

    public void init(String url, String user, String pass) {
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.driver = DriverUtil.identifyDriver(url);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new DbRuntimeException(e, "Get jdbc driver from [{}] error!", url);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public DbConfig setDriver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public DbConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public DbConfig setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public DbConfig setPass(String pass) {
        this.pass = pass;
        return this;
    }

    public Properties getConnProps() {
        return this.connProps;
    }

    public DbConfig setConnProps(Properties connProps) {
        this.connProps = connProps;
        return this;
    }

    public DbConfig addConnProps(String key, String value) {
        if (null == this.connProps) {
            this.connProps = new Properties();
        }
        this.connProps.setProperty(key, value);
        return this;
    }

    public Properties getPoolProps() {
        return this.poolProps;
    }

    public DbConfig setPoolProps(Properties poolProps) {
        this.poolProps = poolProps;
        return this;
    }

    public DbConfig addPoolProps(String key, String value) {
        if (null == this.poolProps) {
            this.poolProps = new Properties();
        }
        this.poolProps.setProperty(key, value);
        return this;
    }
}

