/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.dbcp;

import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DbConfig;
import org.dromara.hutool.setting.props.Props;

public class DbcpDSFactory
implements DSFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public String getDataSourceName() {
        return "commons-dbcp2";
    }

    @Override
    public DataSource createDataSource(DbConfig config) {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(config.getUrl());
        ds.setDriverClassName(config.getDriver());
        ds.setUsername(config.getUser());
        ds.setPassword(config.getPass());
        Props.of(config.getPoolProps()).toBean(ds);
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty(connProps)) {
            connProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> ds.addConnectionProperty(key.toString(), value.toString())));
        }
        return ds;
    }
}

