/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.jndi;

import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.db.ds.DbConfig;

public class JndiDSFactory
implements DSFactory {
    private static final long serialVersionUID = 1573625812927370432L;

    @Override
    public String getDataSourceName() {
        return "JNDI DataSource";
    }

    @Override
    public DataSource createDataSource(DbConfig config) {
        String jndiName = config.getPoolProps().getProperty("jndi");
        if (StrUtil.isEmpty(jndiName)) {
            throw new DbRuntimeException("No setting name [jndi] for this group.");
        }
        return DSUtil.getJndiDS(jndiName);
    }
}

