/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date.format.parser;

import java.util.Locale;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.format.DefaultDateBasic;
import org.dromara.hutool.core.date.format.FastDateFormat;
import org.dromara.hutool.core.date.format.parser.PredicateDateParser;
import org.dromara.hutool.core.text.StrUtil;

public class RFC2822DateParser
extends DefaultDateBasic
implements PredicateDateParser {
    private static final long serialVersionUID = 1L;
    private static final String KEYWORDS_LOCALE_CHINA = "\u661f\u671f";
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    public static RFC2822DateParser INSTANCE = new RFC2822DateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return StrUtil.containsAnyIgnoreCase(dateStr, wtb);
    }

    @Override
    public DateTime parse(String source) {
        if (StrUtil.contains((CharSequence)source, ',')) {
            if (StrUtil.contains((CharSequence)source, KEYWORDS_LOCALE_CHINA)) {
                return new DateTime((CharSequence)source, FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss z", Locale.CHINA));
            }
            return new DateTime((CharSequence)source, DatePattern.HTTP_DATETIME_FORMAT);
        }
        if (StrUtil.contains((CharSequence)source, KEYWORDS_LOCALE_CHINA)) {
            return new DateTime((CharSequence)source, FastDateFormat.getInstance("EEE MMM dd HH:mm:ss zzz yyyy", Locale.CHINA));
        }
        return new DateTime((CharSequence)source, DatePattern.JDK_DATETIME_FORMAT);
    }
}

