/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron;

import java.io.Serializable;
import org.dromara.hutool.core.date.DateUnit;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.cron.Scheduler;
import org.dromara.hutool.log.Log;

public class CronTimer
extends Thread
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.get();
    private final long TIMER_UNIT_SECOND = DateUnit.SECOND.getMillis();
    private final long TIMER_UNIT_MINUTE = DateUnit.MINUTE.getMillis();
    private boolean isStop;
    private final Scheduler scheduler;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long timerUnit = this.scheduler.config.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long thisTime = System.currentTimeMillis();
        while (!this.isStop) {
            long nextTime = (thisTime / timerUnit + 1L) * timerUnit;
            long sleep = nextTime - System.currentTimeMillis();
            if (CronTimer.isValidSleepMillis(sleep, timerUnit)) {
                if (!ThreadUtil.safeSleep(sleep)) break;
                this.spawnLauncher(nextTime);
                thisTime = nextTime;
                continue;
            }
            thisTime = System.currentTimeMillis();
        }
        log.debug("Hutool-cron timer stopped.", new Object[0]);
    }

    public synchronized void stopTimer() {
        this.isStop = true;
        ThreadUtil.interrupt(this, true);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.taskLauncherManager.spawnLauncher(millis);
    }

    private static boolean isValidSleepMillis(long millis, long timerUnit) {
        return millis > 0L && millis < 2L * timerUnit;
    }
}

