/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.spring;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.reflect.TypeReference;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringUtil
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static ConfigurableApplicationContext applicationContext;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        SpringUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static ListableBeanFactory getBeanFactory() {
        ConfigurableApplicationContext factory = applicationContext;
        if (null == factory) {
            throw new HutoolException("No ConfigurableListableBeanFactory or ApplicationContext injected, maybe not in the Spring environment?");
        }
        return factory;
    }

    public static ConfigurableListableBeanFactory getConfigurableBeanFactory() throws HutoolException {
        return applicationContext.getBeanFactory();
    }

    public static <T> T getBean(String name) {
        return (T)SpringUtil.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtil.getBeanFactory().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtil.getBeanFactory().getBean(name, clazz);
    }

    public static <T> T getBean(TypeReference<T> reference) {
        ParameterizedType parameterizedType = (ParameterizedType)reference.getType();
        Class rawType = (Class)parameterizedType.getRawType();
        Class[] genericTypes = (Class[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> (Class)type).toArray(Class[]::new);
        String[] beanNames = SpringUtil.getBeanFactory().getBeanNamesForType(ResolvableType.forClassWithGenerics((Class)rawType, (Class[])genericTypes));
        return SpringUtil.getBean(beanNames[0], rawType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return SpringUtil.getBeanFactory().getBeansOfType(type);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return SpringUtil.getBeanFactory().getBeanNamesForType(type);
    }

    public static String getProperty(String key) {
        ConfigurableEnvironment environment = SpringUtil.getEnvironment();
        return null == environment ? null : environment.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        ConfigurableEnvironment environment = SpringUtil.getEnvironment();
        return null == environment ? null : environment.getProperty(key, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        ConfigurableEnvironment environment = SpringUtil.getEnvironment();
        return (T)(null == environment ? null : environment.getProperty(key, targetType, defaultValue));
    }

    public static ConfigurableEnvironment getEnvironment() {
        return null == applicationContext ? null : applicationContext.getEnvironment();
    }

    public static String getApplicationName() {
        return SpringUtil.getProperty("spring.application.name");
    }

    public static String[] getActiveProfiles() {
        if (null == applicationContext) {
            return null;
        }
        return applicationContext.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        String[] activeProfiles = SpringUtil.getActiveProfiles();
        return ArrayUtil.isNotEmpty(activeProfiles) ? activeProfiles[0] : null;
    }

    public static <T> void registerBean(String beanName, T bean) {
        ConfigurableListableBeanFactory factory = SpringUtil.getConfigurableBeanFactory();
        factory.autowireBean(bean);
        factory.registerSingleton(beanName, bean);
    }

    public static void unregisterBean(String beanName) {
        ConfigurableListableBeanFactory factory = SpringUtil.getConfigurableBeanFactory();
        if (!(factory instanceof DefaultSingletonBeanRegistry)) {
            throw new HutoolException("Can not unregister bean, the factory is not a DefaultSingletonBeanRegistry!");
        }
        DefaultSingletonBeanRegistry registry = (DefaultSingletonBeanRegistry)factory;
        registry.destroySingleton(beanName);
    }

    public static void publishEvent(ApplicationEvent event) {
        if (null != applicationContext) {
            applicationContext.publishEvent(event);
        }
    }

    public static void publishEvent(Object event) {
        if (null != applicationContext) {
            applicationContext.publishEvent(event);
        }
    }
}

