/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serialize;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serialize.JSONDeserializer;
import org.dromara.hutool.json.serialize.JSONSerializer;

public class TemporalAccessorSerializer
implements JSONSerializer<JSONObject, TemporalAccessor>,
JSONDeserializer<TemporalAccessor> {
    private static final String YEAR_KEY = "year";
    private static final String MONTH_KEY = "month";
    private static final String DAY_KEY = "day";
    private static final String HOUR_KEY = "hour";
    private static final String MINUTE_KEY = "minute";
    private static final String SECOND_KEY = "second";
    private static final String NANO_KEY = "nano";
    private final Class<? extends TemporalAccessor> temporalAccessorClass;

    public TemporalAccessorSerializer(Class<? extends TemporalAccessor> temporalAccessorClass) {
        this.temporalAccessorClass = temporalAccessorClass;
    }

    @Override
    public void serialize(JSONObject json, TemporalAccessor bean) {
        if (bean instanceof LocalDate) {
            LocalDate localDate = (LocalDate)bean;
            json.set(YEAR_KEY, localDate.getYear());
            json.set(MONTH_KEY, localDate.getMonthValue());
            json.set(DAY_KEY, localDate.getDayOfMonth());
        } else if (bean instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)bean;
            json.set(YEAR_KEY, localDateTime.getYear());
            json.set(MONTH_KEY, localDateTime.getMonthValue());
            json.set(DAY_KEY, localDateTime.getDayOfMonth());
            json.set(HOUR_KEY, localDateTime.getHour());
            json.set(MINUTE_KEY, localDateTime.getMinute());
            json.set(SECOND_KEY, localDateTime.getSecond());
            json.set(NANO_KEY, localDateTime.getNano());
        } else if (bean instanceof LocalTime) {
            LocalTime localTime = (LocalTime)bean;
            json.set(HOUR_KEY, localTime.getHour());
            json.set(MINUTE_KEY, localTime.getMinute());
            json.set(SECOND_KEY, localTime.getSecond());
            json.set(NANO_KEY, localTime.getNano());
        } else {
            throw new JSONException("Unsupported type to JSON: {}", bean.getClass().getName());
        }
    }

    @Override
    public TemporalAccessor deserialize(JSON json) {
        JSONObject jsonObject = (JSONObject)json;
        if (LocalDate.class.equals(this.temporalAccessorClass) || LocalDateTime.class.equals(this.temporalAccessorClass)) {
            Integer day;
            Integer year = jsonObject.getInt(YEAR_KEY);
            Assert.notNull(year, "Field 'year' must be not null", new Object[0]);
            String monthStr = jsonObject.getStr(MONTH_KEY);
            Assert.notNull(monthStr, "Field 'month' must be not null", new Object[0]);
            Integer month = NumberUtil.parseInt(monthStr, null);
            if (null == month) {
                Month monthEnum = Month.valueOf(monthStr);
                month = monthEnum.getValue();
            }
            if (null == (day = jsonObject.getInt(DAY_KEY))) {
                day = jsonObject.getInt("dayOfMonth");
                Assert.notNull(day, "Field 'day' or 'dayOfMonth' must be not null", new Object[0]);
            }
            LocalDate localDate = LocalDate.of((int)year, month, (int)day);
            if (LocalDate.class.equals(this.temporalAccessorClass)) {
                return localDate;
            }
            LocalTime localTime = LocalTime.of(jsonObject.getInt(HOUR_KEY, 0), jsonObject.getInt(MINUTE_KEY, 0), jsonObject.getInt(SECOND_KEY, 0), jsonObject.getInt(NANO_KEY, 0));
            return LocalDateTime.of(localDate, localTime);
        }
        if (LocalTime.class.equals(this.temporalAccessorClass)) {
            return LocalTime.of(jsonObject.getInt(HOUR_KEY), jsonObject.getInt(MINUTE_KEY), jsonObject.getInt(SECOND_KEY), jsonObject.getInt(NANO_KEY));
        }
        throw new JSONException("Unsupported type from JSON: {}", this.temporalAccessorClass);
    }
}

