/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.csv.CsvData;
import org.dromara.hutool.poi.csv.CsvWriteConfig;

public final class CsvWriter
implements Closeable,
Flushable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;
    private boolean isFirstLine = true;

    public CsvWriter(String filePath) {
        this(FileUtil.file(filePath));
    }

    public CsvWriter(File file) {
        this(file, CharsetUtil.UTF_8);
    }

    public CsvWriter(String filePath, Charset charset) {
        this(FileUtil.file(filePath), charset);
    }

    public CsvWriter(File file, Charset charset) {
        this(file, charset, false);
    }

    public CsvWriter(String filePath, Charset charset, boolean isAppend) {
        this(FileUtil.file(filePath), charset, isAppend);
    }

    public CsvWriter(File file, Charset charset, boolean isAppend) {
        this(file, charset, isAppend, null);
    }

    public CsvWriter(String filePath, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileUtil.file(filePath), charset, isAppend, config);
    }

    public CsvWriter(File file, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileUtil.getWriter(file, charset, isAppend), isAppend ? (config == null ? CsvWriteConfig.defaultConfig().setEndingLineBreak(true) : config.setEndingLineBreak(true)) : config);
    }

    public CsvWriter(Writer writer) {
        this(writer, null);
    }

    public CsvWriter(Writer writer, CsvWriteConfig config) {
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter(writer);
        this.config = ObjUtil.defaultIfNull(config, CsvWriteConfig::defaultConfig);
    }

    public CsvWriter setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.config.setAlwaysDelimitText(alwaysDelimitText);
        return this;
    }

    public CsvWriter setLineDelimiter(char[] lineDelimiter) {
        this.config.setLineDelimiter(lineDelimiter);
        return this;
    }

    public CsvWriter setDdeSafe(boolean ddeSafe) {
        this.config.setDdeSafe(ddeSafe);
        return this;
    }

    public CsvWriter write(String[] ... lines) throws IORuntimeException {
        return this.write(new ArrayIter((E[])lines));
    }

    public CsvWriter write(Iterable<?> lines) throws IORuntimeException {
        if (CollUtil.isNotEmpty(lines)) {
            for (Object values : lines) {
                this.appendLine(Convert.toStrArray(values));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter write(CsvData csvData) {
        if (csvData != null) {
            List<String> header = csvData.getHeader();
            if (CollUtil.isNotEmpty(header)) {
                this.writeHeaderLine(header.toArray(new String[0]));
            }
            this.write(csvData.getRows());
            this.flush();
        }
        return this;
    }

    public CsvWriter writeBeans(Iterable<?> beans, String ... properties) {
        if (CollUtil.isNotEmpty(beans)) {
            boolean isFirst = true;
            for (Object bean : beans) {
                Map<String, Object> map = BeanUtil.beanToMap(bean, properties);
                if (isFirst) {
                    this.writeHeaderLine(map.keySet().toArray(new String[0]));
                    isFirst = false;
                }
                this.writeLine(Convert.toStrArray(map.values()));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter writeHeaderLine(String ... fields) throws IORuntimeException {
        Map headerAlias = this.config.headerAlias;
        if (MapUtil.isNotEmpty(headerAlias)) {
            for (int i = 0; i < fields.length; ++i) {
                String alias = (String)headerAlias.get(fields[i]);
                if (null == alias) continue;
                fields[i] = alias;
            }
        }
        return this.writeLine(fields);
    }

    public CsvWriter writeLine(String ... fields) throws IORuntimeException {
        if (ArrayUtil.isEmpty(fields)) {
            return this.writeLine();
        }
        this.appendLine(fields);
        return this;
    }

    public CsvWriter writeLine() throws IORuntimeException {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        this.newline = true;
        return this;
    }

    public CsvWriter writeComment(String comment) {
        Assert.notNull(this.config.commentCharacter, "Comment is disable!", new Object[0]);
        try {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            this.writer.write(this.config.commentCharacter.charValue());
            this.writer.write(comment);
            this.newline = true;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.config.endingLineBreak) {
            this.writeLine();
        }
        IoUtil.closeQuietly(this.writer);
    }

    @Override
    public void flush() throws IORuntimeException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private void appendLine(String ... fields) throws IORuntimeException {
        try {
            this.doAppendLine(fields);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private void doAppendLine(String ... fields) throws IOException {
        if (null != fields) {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            for (String field : fields) {
                this.appendField(field);
            }
            this.newline = true;
        }
    }

    private void appendField(String value) throws IOException {
        boolean alwaysDelimitText = this.config.alwaysDelimitText;
        char textDelimiter = this.config.textDelimiter;
        char fieldSeparator = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(fieldSeparator);
        } else {
            this.newline = false;
        }
        if (null == value) {
            if (alwaysDelimitText) {
                this.writer.write(new char[]{textDelimiter, textDelimiter});
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean needsTextDelimiter = alwaysDelimitText;
        boolean containsTextDelimiter = false;
        for (char c : valueChars) {
            if (c == textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
        if (this.config.ddeSafe && CsvWriter.isDDEUnsafeChar(valueChars[0])) {
            this.writer.write(39);
        }
        if (containsTextDelimiter) {
            for (char c : valueChars) {
                if (c == textDelimiter) {
                    this.writer.write(textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            this.writer.write(valueChars);
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
    }

    private static boolean isDDEUnsafeChar(char c) {
        return c == '@' || c == '+' || c == '-' || c == '=';
    }
}

