/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.queue;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class CheckedLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    protected final Predicate<E> checker;

    public CheckedLinkedBlockingQueue(Predicate<E> checker) {
        super(Integer.MAX_VALUE);
        this.checker = checker;
    }

    public CheckedLinkedBlockingQueue(Collection<? extends E> c, Predicate<E> checker) {
        super(c);
        this.checker = checker;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.checker.test(e)) {
            super.put(e);
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.checker.test(e) && super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.checker.test(e) && super.offer(e);
    }
}

