/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class ZoneUtil {
    public static final TimeZone ZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final ZoneId ZONE_ID_UTC = ZONE_UTC.toZoneId();

    public static TimeZone toTimeZone(ZoneId zoneId) {
        if (null == zoneId) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(zoneId);
    }

    public static ZoneId toZoneId(TimeZone timeZone) {
        if (null == timeZone) {
            return ZoneId.systemDefault();
        }
        return timeZone.toZoneId();
    }

    public static TimeZone getTimeZoneByOffset(int rawOffset, TimeUnit timeUnit) {
        String id = ZoneUtil.getAvailableID(rawOffset, timeUnit);
        return null == id ? null : TimeZone.getTimeZone(id);
    }

    public static String getAvailableID(int rawOffset, TimeUnit timeUnit) {
        String[] availableIDs = TimeZone.getAvailableIDs((int)ObjUtil.defaultIfNull(timeUnit, TimeUnit.MILLISECONDS).toMillis(rawOffset));
        return ArrayUtil.isEmpty(availableIDs) ? null : availableIDs[0];
    }
}

