/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.page;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.range.DefaultSegment;
import org.dromara.hutool.core.lang.range.Segment;
import org.dromara.hutool.core.math.NumberUtil;

public class PageInfo {
    private static final int DEFAULT_PAGE_SIZE = 10;
    int total;
    int pageSize;
    int pageCount;
    int firstPageNo;
    int pageNo;

    public static PageInfo of(int total, int pageSize) {
        return new PageInfo(total, pageSize);
    }

    public PageInfo(int total, int pageSize) {
        this.pageNo = this.firstPageNo = 1;
        this.init(total, pageSize);
    }

    private void init(int total, int pageSize) {
        Assert.isTrue(total >= 0, "Total must >= 0", new Object[0]);
        this.total = total;
        if (pageSize < 1) {
            pageSize = 10;
        }
        this.pageSize = pageSize;
        this.pageCount = NumberUtil.count(total, pageSize);
    }

    public int getTotal() {
        return this.total;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public boolean isFirstPage() {
        return this.getPageIndexBase1() == 1;
    }

    public boolean isLastPage() {
        return this.getPageIndexBase1() == this.pageCount;
    }

    public boolean hasPreviousPage() {
        return this.getPageIndexBase1() > 1;
    }

    public boolean hasNextPage() {
        return this.getBeginIndex() < this.pageCount;
    }

    public boolean isValidPage() {
        return this.getPageIndexBase1() <= this.pageCount;
    }

    public int getBeginIndex() {
        return (this.getPageIndexBase1() - 1) * this.pageSize;
    }

    public int getEndIndexExclude() {
        return this.getEndIndex() + 1;
    }

    public int getEndIndex() {
        int begin = this.getBeginIndex();
        int end = begin + this.pageSize - 1;
        if (begin <= this.total && end > this.total) {
            end = this.total;
        }
        return end;
    }

    public Segment<Integer> getSegment() {
        return new DefaultSegment<Integer>(this.getBeginIndex(), this.getEndIndex());
    }

    public int getFirstPageNo() {
        return this.firstPageNo;
    }

    public PageInfo setFirstPageNo(int firstPageNo) {
        this.firstPageNo = firstPageNo;
        return this;
    }

    public PageInfo setPageNo(int pageNo) {
        this.pageNo = Math.max(pageNo, this.firstPageNo);
        return this;
    }

    public PageInfo nextPage() {
        return this.setPageNo(this.pageNo + 1);
    }

    public PageInfo previousPage() {
        return this.setPageNo(this.pageNo - 1);
    }

    public String toString() {
        return "{total=" + this.total + ",pages=" + this.pageCount + ",pageNumber=" + this.pageNo + ",limit=" + this.pageSize + ",isFirstPage=" + this.isFirstPage() + ",isLastPage=" + this.isLastPage() + ",hasPreviousPage=" + this.hasPreviousPage() + ",hasNextPage=" + this.hasNextPage() + "}";
    }

    private int getPageIndexBase1() {
        return this.pageNo - this.firstPageNo + 1;
    }
}

