/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.stream.EasyStream;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.dfa.FoundWord;
import org.dromara.hutool.core.text.dfa.StopChar;

public class WordTree
extends HashMap<Character, WordTree> {
    private static final long serialVersionUID = -4646423269465809276L;
    private Set<Character> endCharacterSet = null;
    private Predicate<Character> charFilter = StopChar::isNotStopChar;

    public static WordTree of(String ... words) {
        WordTree wordTree = new WordTree(words.length);
        for (String word : words) {
            wordTree.addWord(word);
        }
        return wordTree;
    }

    public WordTree() {
    }

    public WordTree(int initialCapacity) {
        super((int)((float)initialCapacity / 0.75f) + 1);
    }

    public WordTree setCharFilter(Predicate<Character> charFilter) {
        this.charFilter = charFilter;
        return this;
    }

    public WordTree addWords(Collection<String> words) {
        if (!(words instanceof Set)) {
            words = new HashSet<String>(words);
        }
        for (String word : words) {
            this.addWord(word);
        }
        return this;
    }

    public WordTree addWords(String ... words) {
        for (String word : SetUtil.of(words)) {
            this.addWord(word);
        }
        return this;
    }

    public WordTree addWord(String word) {
        if (null == word) {
            return this;
        }
        Predicate<Character> charFilter = this.charFilter;
        WordTree parent = null;
        WordTree current = this;
        char currentChar = '\u0000';
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            currentChar = word.charAt(i);
            if (!charFilter.test(Character.valueOf(currentChar))) continue;
            WordTree child = current.computeIfAbsent(Character.valueOf(currentChar), c -> new WordTree(1));
            parent = current;
            current = child;
        }
        if (null != parent) {
            super.setEnd(currentChar);
        }
        return this;
    }

    public boolean isMatch(String text) {
        return null != this.matchWord(text);
    }

    public String match(String text) {
        FoundWord foundWord = this.matchWord(text);
        return null != foundWord ? foundWord.toString() : null;
    }

    public FoundWord matchWord(String text) {
        if (null == text) {
            return null;
        }
        List<FoundWord> matchAll = this.matchAllWords(text, 1);
        return CollUtil.get(matchAll, 0);
    }

    public List<String> matchAll(String text) {
        return this.matchAll(text, -1);
    }

    public List<FoundWord> matchAllWords(String text) {
        return this.matchAllWords(text, -1);
    }

    public List<String> matchAll(String text, int limit) {
        return this.matchAll(text, limit, false, false);
    }

    public List<FoundWord> matchAllWords(String text, int limit) {
        return this.matchAllWords(text, limit, false, false);
    }

    public List<String> matchAll(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        List<FoundWord> matchAllWords = this.matchAllWords(text, limit, isDensityMatch, isGreedMatch);
        return CollUtil.map(matchAllWords, FoundWord::toString);
    }

    public List<FoundWord> matchAllWords(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        if (null == text) {
            return null;
        }
        ArrayList<FoundWord> foundWords = limit > 0 ? new ArrayList<FoundWord>(limit) : new ArrayList();
        int length = text.length();
        Predicate<Character> charFilter = this.charFilter;
        StringBuilder wordBuffer = StrUtil.builder();
        StringBuilder keyBuffer = StrUtil.builder();
        for (int i = 0; i < length; ++i) {
            WordTree current = this;
            wordBuffer.setLength(0);
            keyBuffer.setLength(0);
            FoundWord currentFoundWord = null;
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (!charFilter.test(Character.valueOf(currentChar))) {
                    if (wordBuffer.length() > 0) {
                        wordBuffer.append(currentChar);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                wordBuffer.append(currentChar);
                keyBuffer.append(currentChar);
                if (current.isEnd(currentChar)) {
                    currentFoundWord = new FoundWord(keyBuffer.toString(), wordBuffer.toString(), i, j);
                    if (!isDensityMatch) {
                        i = j;
                    }
                    if (!isGreedMatch) break;
                }
                current = (WordTree)current.get(Character.valueOf(currentChar));
            }
            if (null == currentFoundWord) continue;
            foundWords.add(currentFoundWord);
            if (limit <= 0 || foundWords.size() < limit) continue;
            return foundWords;
        }
        return foundWords;
    }

    public List<String> flatten() {
        return EasyStream.of(this.entrySet()).flat(this::innerFlatten).toList();
    }

    private Iterable<String> innerFlatten(Map.Entry<Character, WordTree> entry) {
        List<String> list = EasyStream.of(entry.getValue().entrySet()).flat(this::innerFlatten).map(v -> entry.getKey() + v).toList();
        if (list.isEmpty()) {
            return EasyStream.of(entry.getKey().toString());
        }
        return list;
    }

    private boolean isEnd(char c) {
        return null != this.endCharacterSet && this.endCharacterSet.contains(Character.valueOf(c));
    }

    private void setEnd(char c) {
        if (null == this.endCharacterSet) {
            this.endCharacterSet = new HashSet<Character>(2);
        }
        this.endCharacterSet.add(Character.valueOf(c));
    }

    @Override
    public void clear() {
        super.clear();
        if (null != this.endCharacterSet) {
            this.endCharacterSet.clear();
        }
    }
}

