/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.thymeleaf;

import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.thymeleaf.ThymeleafTemplate;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafEngine
implements TemplateEngine {
    org.thymeleaf.TemplateEngine engine;
    TemplateConfig config;

    public ThymeleafEngine() {
    }

    public ThymeleafEngine(TemplateConfig config) {
        this.init(config);
    }

    public ThymeleafEngine(org.thymeleaf.TemplateEngine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.config = config;
        this.init(ThymeleafEngine.createEngine(config));
        return this;
    }

    private void init(org.thymeleaf.TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return ThymeleafTemplate.wrap(this.engine, resource, null == this.config ? null : this.config.getCharset());
    }

    @Override
    public org.thymeleaf.TemplateEngine getRaw() {
        return this.engine;
    }

    private static org.thymeleaf.TemplateEngine createEngine(TemplateConfig config) {
        StringTemplateResolver resolver;
        if (null == config) {
            config = new TemplateConfig();
        }
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                ClassLoaderTemplateResolver classLoaderResolver = new ClassLoaderTemplateResolver();
                classLoaderResolver.setCharacterEncoding(config.getCharsetStr());
                classLoaderResolver.setTemplateMode(TemplateMode.HTML);
                classLoaderResolver.setPrefix(StrUtil.addSuffixIfNot(config.getPath(), "/"));
                resolver = classLoaderResolver;
                break;
            }
            case FILE: {
                FileTemplateResolver fileResolver = new FileTemplateResolver();
                fileResolver.setCharacterEncoding(config.getCharsetStr());
                fileResolver.setTemplateMode(TemplateMode.HTML);
                fileResolver.setPrefix(StrUtil.addSuffixIfNot(config.getPath(), "/"));
                resolver = fileResolver;
                break;
            }
            case WEB_ROOT: {
                FileTemplateResolver webRootResolver = new FileTemplateResolver();
                webRootResolver.setCharacterEncoding(config.getCharsetStr());
                webRootResolver.setTemplateMode(TemplateMode.HTML);
                webRootResolver.setPrefix(StrUtil.addSuffixIfNot(FileUtil.getAbsolutePath(FileUtil.file(FileUtil.getWebRoot(), config.getPath())), "/"));
                resolver = webRootResolver;
                break;
            }
            case STRING: {
                resolver = new StringTemplateResolver();
                break;
            }
            default: {
                resolver = new DefaultTemplateResolver();
            }
        }
        org.thymeleaf.TemplateEngine engine = new org.thymeleaf.TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)resolver);
        return engine;
    }
}

