/*
 * Copyright (c) 2024 looly(loolly@aliyun.com)
 * Hutool is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          https://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package org.dromara.hutool.json.writer;

import org.dromara.hutool.json.serialize.DateJSONString;

import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期类型的值写出器<br>
 * 支持包括：{@link Date}、{@link Calendar}、{@link TemporalAccessor}
 *
 * @author looly
 * @since 6.0.0
 */
public class DateValueWriter implements JSONValueWriter {
	/**
	 * 单例对象
	 */
	public static final DateValueWriter INSTANCE = new DateValueWriter();

	@Override
	public boolean test(final Object value) {
		return value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor;
	}

	@Override
	public void write(final JSONWriter writer, final Object value) {
		writer.writeRaw(new DateJSONString(value, writer.getConfig()).toJSONString());
	}
}
