/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.Iterator;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.ReentrantCache;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.map.FixedLinkedHashMap;

public class LRUCache<K, V>
extends ReentrantCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        FixedLinkedHashMap fixedLinkedHashMap = new FixedLinkedHashMap(capacity);
        fixedLinkedHashMap.setRemoveListener(entry -> {
            if (null != this.listener) {
                this.listener.onRemove(((Mutable)entry.getKey()).get(), ((CacheObj)entry.getValue()).getValue());
            }
        });
        this.cacheMap = fixedLinkedHashMap;
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }
}

