/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import org.dromara.hutool.core.cache.CacheListener;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.TimedCache;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.lang.ref.Ref;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;

public class WeakCache<K, V>
extends TimedCache<K, V> {
    private static final long serialVersionUID = 1L;

    public WeakCache(long timeout) {
        super(timeout, new WeakConcurrentMap());
    }

    @Override
    public WeakCache<K, V> setListener(CacheListener<K, V> listener) {
        super.setListener((CacheListener)listener);
        WeakConcurrentMap map = (WeakConcurrentMap)this.cacheMap;
        map.setPurgeListener((key, value) -> listener.onRemove(Opt.ofNullable(key).map(Ref::get).map(Mutable::get).get(), Opt.ofNullable(value).map(Ref::get).map(CacheObj::getValue).get()));
        return this;
    }
}

