/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ReferenceConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static ReferenceConverter INSTANCE = new ReferenceConverter();

    @Override
    protected Reference<?> convertInternal(Class<?> targetClass, Object value) {
        Object targetValue = null;
        Type paramType = TypeUtil.getTypeArgument(targetClass);
        if (!TypeUtil.isUnknown(paramType)) {
            targetValue = CompositeConverter.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (targetClass == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (targetClass == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupport Reference type: {}", targetClass.getName()));
    }
}

