/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.stream.CollectorUtil;
import org.dromara.hutool.core.stream.spliterators.DropWhileSpliterator;
import org.dromara.hutool.core.stream.spliterators.IterateSpliterator;
import org.dromara.hutool.core.stream.spliterators.TakeWhileSpliterator;
import org.dromara.hutool.core.tree.HierarchyIterator;
import org.dromara.hutool.core.util.CharsetUtil;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        return null == array ? Stream.empty() : Stream.of(array);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        if (null == iterable) {
            return Stream.empty();
        }
        return iterable instanceof Collection ? (parallel ? ((Collection)iterable).parallelStream() : ((Collection)iterable).stream()) : StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator) {
        return StreamUtil.ofIter(iterator, false);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator, boolean parallel) {
        if (null == iterator) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), parallel);
    }

    public static Stream<String> of(File file) {
        return StreamUtil.of(file, CharsetUtil.UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamUtil.of(path, CharsetUtil.UTF_8);
    }

    public static Stream<String> of(File file, Charset charset) {
        if (null == file) {
            return Stream.empty();
        }
        return StreamUtil.of(file.toPath(), charset);
    }

    public static Stream<String> of(Path path, Charset charset) {
        if (null == path) {
            return Stream.empty();
        }
        try {
            return Files.lines(path, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        if (null == stream) {
            return null;
        }
        return stream.collect(CollectorUtil.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        if (null == stream) {
            return null;
        }
        return stream.collect(CollectorUtil.joining(delimiter, toStringFunc));
    }

    public static <T> Stream<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        return StreamSupport.stream(IterateSpliterator.of(seed, hasNext, next), false);
    }

    public static <T> Stream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer, Predicate<T> filter) {
        return StreamUtil.ofIter(HierarchyIterator.breadthFirst(root, discoverer, filter));
    }

    public static <T> Stream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer) {
        return StreamUtil.ofIter(HierarchyIterator.breadthFirst(root, discoverer));
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<? super T> predicate) {
        if (null == source) {
            return Stream.empty();
        }
        Objects.requireNonNull(predicate);
        return StreamUtil.createStatefulNewStream(source, TakeWhileSpliterator.create(source.spliterator(), predicate));
    }

    public static <T> Stream<T> dropWhile(Stream<T> source, Predicate<? super T> predicate) {
        if (null == source) {
            return Stream.empty();
        }
        Objects.requireNonNull(predicate);
        return StreamUtil.createStatefulNewStream(source, DropWhileSpliterator.of(source.spliterator(), predicate));
    }

    private static <T, R> Stream<R> createStatefulNewStream(Stream<T> source, Spliterator<R> newSpliterator) {
        Stream<R> newStream = StreamSupport.stream(newSpliterator, source.isParallel());
        if (source.isParallel()) {
            newStream = newStream.limit(Long.MAX_VALUE);
        }
        return (Stream)newStream.onClose(source::close);
    }
}

