/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.comparator.VersionComparator;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.NamingCase;
import org.dromara.hutool.core.text.StrRegionMatcher;
import org.dromara.hutool.core.text.StrRepeater;
import org.dromara.hutool.core.text.StrTrimer;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.StrValidator;
import org.dromara.hutool.core.text.finder.CharFinder;
import org.dromara.hutool.core.text.finder.CharMatcherFinder;
import org.dromara.hutool.core.text.finder.StrFinder;
import org.dromara.hutool.core.text.placeholder.StrFormatter;
import org.dromara.hutool.core.text.replacer.RangeReplacerByChar;
import org.dromara.hutool.core.text.replacer.RangeReplacerByStr;
import org.dromara.hutool.core.text.replacer.SearchReplacer;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class CharSequenceUtil
extends StrValidator {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String SPACE = " ";

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static String toStringOrNull(Object obj) {
        return null == obj ? null : obj.toString();
    }

    public static String toStringOrEmpty(Object obj) {
        return null == obj ? "" : obj.toString();
    }

    public static CharSequence emptyIfNull(CharSequence str) {
        return null == str ? "" : str;
    }

    public static <T extends CharSequence> T nullIfEmpty(T str) {
        return CharSequenceUtil.isEmpty(str) ? null : (T)str;
    }

    public static <T extends CharSequence> T defaultIfNull(T str, T defaultValue) {
        return ObjUtil.defaultIfNull(str, defaultValue);
    }

    public static <T extends CharSequence> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        return (T)((CharSequence)ObjUtil.defaultIfNull(source, defaultSupplier));
    }

    public static <T extends CharSequence, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, Supplier<? extends R> defaultSupplier) {
        return ObjUtil.defaultIfNull(source, handler, defaultSupplier);
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        return CharSequenceUtil.isEmpty(str) ? defaultValue : str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, Supplier<? extends T> defaultSupplier) {
        return (T)(CharSequenceUtil.isEmpty(str) ? (CharSequence)defaultSupplier.get() : str);
    }

    public static <T extends CharSequence, V> V defaultIfEmpty(T str, Function<T, V> handler, Supplier<? extends V> defaultSupplier) {
        return CharSequenceUtil.isEmpty(str) ? defaultSupplier.get() : handler.apply(str);
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultValue) {
        return CharSequenceUtil.isBlank(str) ? defaultValue : str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, Supplier<? extends T> defaultSupplier) {
        return (T)(CharSequenceUtil.isBlank(str) ? (CharSequence)defaultSupplier.get() : str);
    }

    public static <T extends CharSequence, V> V defaultIfBlank(T str, Function<T, V> handler, Supplier<? extends V> defaultSupplier) {
        return CharSequenceUtil.isBlank(str) ? defaultSupplier.get() : handler.apply(str);
    }

    public static String trim(CharSequence str) {
        return StrTrimer.TRIM_BLANK.apply(str);
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? "" : CharSequenceUtil.trim(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = CharSequenceUtil.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String trimPrefix(CharSequence str) {
        return StrTrimer.TRIM_PREFIX_BLANK.apply(str);
    }

    public static String trimSuffix(CharSequence str) {
        return StrTrimer.TRIM_SUFFIX_BLANK.apply(str);
    }

    public static String trim(CharSequence str, StrTrimer.TrimMode mode) {
        return new StrTrimer(mode, CharUtil::isBlankChar).apply(str);
    }

    public static String trim(CharSequence str, StrTrimer.TrimMode mode, Predicate<Character> predicate) {
        return new StrTrimer(mode, predicate).apply(str);
    }

    public static boolean startWith(CharSequence str, char c) {
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, false, true);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharSequenceUtil.startWith(str, prefix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAnyIgnoreCase(CharSequence str, CharSequence ... prefixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharSequenceUtil.startWith(str, prefix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceUtil.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        return new StrRegionMatcher(ignoreCase, ignoreEquals, true).test(str, prefix);
    }

    public static boolean endWith(CharSequence str, char c) {
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        return CharSequenceUtil.endWith(str, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        return new StrRegionMatcher(ignoreCase, ignoreEquals, false).test(str, suffix);
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return CharSequenceUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (CharSequenceUtil.isNotEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (CharSequenceUtil.isNotEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtil.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!CharSequenceUtil.contains(str, checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return CharSequenceUtil.indexOfIgnoreCase(str, testStr) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!CharSequenceUtil.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static boolean containsAll(CharSequence str, CharSequence ... testChars) {
        if (CharSequenceUtil.isBlank(str) || ArrayUtil.isEmpty(testChars)) {
            return false;
        }
        for (CharSequence testChar : testChars) {
            if (CharSequenceUtil.contains(str, testChar)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return CharSequenceUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        if (CharSequenceUtil.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(searchChar).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOf(CharSequence text, Predicate<Character> matcher, int start, int end) {
        if (CharSequenceUtil.isEmpty(text)) {
            return -1;
        }
        return new CharMatcherFinder(matcher).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(text) || CharSequenceUtil.isEmpty(searchStr)) {
            if (CharSequenceUtil.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return StrFinder.of(searchStr, ignoreCase).setText(text).start(from);
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(text) || CharSequenceUtil.isEmpty(searchStr)) {
            if (CharSequenceUtil.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return StrFinder.of(searchStr, ignoreCase).setText(text).setNegative(true).start(from);
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = CharSequenceUtil.indexOf(str, searchStr, index + 1, false)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(strToRemove)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return str.toString().replace(strToRemove, "");
    }

    public static String removeAny(CharSequence str, CharSequence ... strsToRemove) {
        String result = CharSequenceUtil.toStringOrNull(str);
        if (CharSequenceUtil.isNotEmpty(str)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = CharSequenceUtil.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (StrUtil.isEmpty(str) || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return CharSequenceUtil.filter(str, c -> !ArrayUtil.contains(chars, c.charValue()));
    }

    public static String removeAllLineBreaks(CharSequence str) {
        return CharSequenceUtil.removeAll(str, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removePrefix(str, prefix));
    }

    public static String removeAllPrefix(CharSequence str, CharSequence prefix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String prefixStr = prefix.toString();
        int prefixLength = prefixStr.length();
        String str2 = str.toString();
        int toIndex = 0;
        while (str2.startsWith(prefixStr, toIndex)) {
            toIndex += prefixLength;
        }
        return CharSequenceUtil.subSuf(str2, toIndex);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.removePrefix(str, prefix, false);
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.removePrefix(str, prefix, true);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String str2 = str.toString();
        if (CharSequenceUtil.startWith(str, prefix, ignoreCase)) {
            return CharSequenceUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removeSuffix(str, suffix));
    }

    public static String removeAllSuffix(CharSequence str, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String suffixStr = suffix.toString();
        int suffixLength = suffixStr.length();
        String str2 = str.toString();
        int toIndex = str2.length();
        while (str2.startsWith(suffixStr, toIndex - suffixLength)) {
            toIndex -= suffixLength;
        }
        return CharSequenceUtil.subPre(str2, toIndex);
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return CharSequenceUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String str2 = str.toString();
        if (CharSequenceUtil.endWithIgnoreCase(str, suffix)) {
            return CharSequenceUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceUtil.filter(str, c -> !CharUtil.isBlankChar(c.charValue()));
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return CharSequenceUtil.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return CharSequenceUtil.strip(str, prefix, suffix, true);
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        if (CharSequenceUtil.equals(str, prefixOrSuffix)) {
            return "";
        }
        return CharSequenceUtil.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return CharSequenceUtil.strip(str, prefix, suffix, false);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String str2 = str.toString();
        int from = 0;
        int to = str2.length();
        if (CharSequenceUtil.startWith(str2, prefix, ignoreCase) && (from = prefix.length()) == to) {
            return "";
        }
        if (CharSequenceUtil.endWith(str2, suffix, ignoreCase)) {
            if (from == (to -= suffix.length())) {
                return "";
            }
            if (to < from) {
                to += suffix.length();
            }
        }
        return str2.substring(from, to);
    }

    public static String stripAll(CharSequence str, CharSequence prefixOrSuffix) {
        if (CharSequenceUtil.equals(str, prefixOrSuffix)) {
            return "";
        }
        return CharSequenceUtil.stripAll(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripAll(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        String prefixStr = CharSequenceUtil.toStringOrEmpty(prefix);
        String suffixStr = CharSequenceUtil.toStringOrEmpty(suffix);
        String str2 = str.toString();
        int from = 0;
        int to = str2.length();
        if (!prefixStr.isEmpty()) {
            while (str2.startsWith(prefixStr, from)) {
                if ((from += prefix.length()) != to) continue;
                return "";
            }
        }
        if (!suffixStr.isEmpty()) {
            while (str2.startsWith(suffixStr, to - suffixStr.length())) {
                if (from == (to -= suffixStr.length())) {
                    return "";
                }
                if (to >= from) continue;
                to += suffixStr.length();
                break;
            }
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.prependIfMissing(str, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.appendIfMissing(str, suffix, new CharSequence[0]);
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return "";
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subByCodePoint(CharSequence str, int fromIndex, int toIndex) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        str.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subPreGbk(CharSequence str, int len, CharSequence suffix) {
        return CharSequenceUtil.subPreGbk(str, len, true) + suffix;
    }

    public static String subPreGbk(CharSequence str, int len, boolean halfUp) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int counterOfDoubleByte = 0;
        byte[] b = ByteUtil.toBytes(str, CharsetUtil.GBK);
        if (b.length <= len) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            len = halfUp ? ++len : --len;
        }
        return new String(b, 0, len, CharsetUtil.GBK);
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        if (CharSequenceUtil.isEmpty(string) || string.length() == toIndexExclude) {
            return CharSequenceUtil.toStringOrNull(string);
        }
        return CharSequenceUtil.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (0 == fromIndex || CharSequenceUtil.isEmpty(string)) {
            return CharSequenceUtil.toStringOrNull(string);
        }
        return CharSequenceUtil.sub(string, fromIndex, string.length());
    }

    public static String subSufByLength(CharSequence string, int length) {
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        return CharSequenceUtil.sub(string, -length, string.length());
    }

    public static String subByLength(String input, int fromIndex, int length) {
        if (CharSequenceUtil.isEmpty(input)) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        int toIndex = fromIndex < 0 ? fromIndex - length : fromIndex + length;
        return CharSequenceUtil.sub(input, fromIndex, toIndex);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return CharSequenceUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.hasEmpty(str, prefix, suffix) || !CharSequenceUtil.contains(str, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = SplitUtil.splitToArray(str, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (int i = 1; i < split.length; ++i) {
                String fragment = split[i];
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.subBetweenAll(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        return StrRepeater.of(count).repeat(c);
    }

    public static String repeat(CharSequence str, int count) {
        if (null == str) {
            return null;
        }
        return StrRepeater.of(count).repeat(str);
    }

    public static String repeatByLength(CharSequence str, int padLen) {
        if (null == str) {
            return null;
        }
        if (padLen <= 0) {
            return "";
        }
        return StrRepeater.of(padLen).repeatByLength(str);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        if (count <= 0) {
            return "";
        }
        return StrRepeater.of(count).repeatAndJoin(str, delimiter);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, true, strs);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        if (null == str || position < 0) {
            return false;
        }
        return str.length() > position && c == str.charAt(position);
    }

    public static boolean isSubEquals(CharSequence str1, int offset1, CharSequence str2, boolean ignoreCase) {
        return CharSequenceUtil.isSubEquals(str1, offset1, str2, 0, str2.length(), ignoreCase);
    }

    public static boolean isSubEquals(CharSequence str1, int offset1, CharSequence str2, int offset2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, offset1, str2.toString(), offset2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        if (ArrayUtil.isEmpty(params) || CharSequenceUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return CharSequenceUtil.toStringOrEmpty(prefix).concat(CharSequenceUtil.toStringOrEmpty(str)).concat(CharSequenceUtil.toStringOrEmpty(suffix));
    }

    public static String wrap(CharSequence str, char prefix, char suffix) {
        return prefix + CharSequenceUtil.toStringOrEmpty(str) + suffix;
    }

    public static String[] wrapAllWithPair(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (CharSequenceUtil.isNotEmpty(str)) {
            len += str.length();
        }
        if (CharSequenceUtil.isNotEmpty(prefix)) {
            len += prefix.length();
        }
        if (CharSequenceUtil.isNotEmpty(suffix)) {
            len += suffix.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (CharSequenceUtil.isNotEmpty(prefix) && !CharSequenceUtil.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (CharSequenceUtil.isNotEmpty(str)) {
            sb.append(str);
        }
        if (CharSequenceUtil.isNotEmpty(suffix) && !CharSequenceUtil.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllWithPairIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (CharSequenceUtil.isWrap(str, prefix, suffix)) {
            return CharSequenceUtil.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        if (CharSequenceUtil.isWrap(str, prefix, suffix)) {
            return CharSequenceUtil.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return CharSequenceUtil.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (ArrayUtil.hasNull(str, prefix, suffix)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return CharSequenceUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return CharSequenceUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str || str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str, int length, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeatByLength(padStr, length - strLen).concat(str.toString());
    }

    public static String padPre(CharSequence str, int length, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeat(padChar, length - strLen).concat(str.toString());
    }

    public static String padAfter(CharSequence str, int length, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.sub(str, strLen - length, strLen);
        }
        return str.toString().concat(CharSequenceUtil.repeat(padChar, length - strLen));
    }

    public static String padAfter(CharSequence str, int length, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subSufByLength(str, length);
        }
        return str.toString().concat(CharSequenceUtil.repeatByLength(padStr, length - strLen));
    }

    public static String center(CharSequence str, int size) {
        return CharSequenceUtil.center(str, size, ' ');
    }

    public static String center(CharSequence str, int size, char padChar) {
        if (str == null || size <= 0) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        str = CharSequenceUtil.padPre(str, strLen + pads / 2, padChar);
        str = CharSequenceUtil.padAfter(str, size, padChar);
        return str.toString();
    }

    public static String center(CharSequence str, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        if (CharSequenceUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        str = CharSequenceUtil.padPre(str, strLen + pads / 2, padStr);
        str = CharSequenceUtil.padAfter(str, size, padStr);
        return str.toString();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharSequenceUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharSequenceUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int compareVersion(CharSequence version1, CharSequence version2) {
        return VersionComparator.INSTANCE.compare(CharSequenceUtil.toStringOrNull(version1), CharSequenceUtil.toStringOrNull(version2));
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || CharSequenceUtil.isEmpty(suffix) || CharSequenceUtil.endWith(str, suffix, ignoreCase)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        if (ArrayUtil.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceUtil.endWith(str, testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || CharSequenceUtil.isEmpty(prefix) || CharSequenceUtil.startWith(str, prefix, ignoreCase)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        if (ArrayUtil.isNotEmpty(prefixes)) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceUtil.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String replaceFirst(CharSequence str, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int startInclude = CharSequenceUtil.indexOf(str, searchStr, 0, ignoreCase);
        if (-1 == startInclude) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return CharSequenceUtil.replaceByCodePoint(str, startInclude, startInclude + searchStr.length(), replacedStr);
    }

    public static String replaceLast(CharSequence str, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int lastIndex = CharSequenceUtil.lastIndexOf(str, searchStr, str.length(), ignoreCase);
        if (-1 == lastIndex) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return CharSequenceUtil.replace(str, lastIndex, searchStr, replacedStr, ignoreCase);
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(searchStr)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return new SearchReplacer(fromIndex, searchStr, replacement, ignoreCase).apply(str);
    }

    public static String replaceByCodePoint(CharSequence str, int beginInclude, int endExclude, char replacedChar) {
        return new RangeReplacerByChar(beginInclude, endExclude, replacedChar, true).apply(str);
    }

    public static String replaceByCodePoint(CharSequence str, int beginInclude, int endExclude, CharSequence replacedStr) {
        return new RangeReplacerByStr(beginInclude, endExclude, replacedStr, true).apply(str);
    }

    public static String replace(CharSequence str, Pattern pattern, SerFunction<Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, pattern, replaceFun);
    }

    public static String replace(CharSequence str, String regex, SerFunction<Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, regex, replaceFun);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return CharSequenceUtil.replaceByCodePoint(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(chars)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return CharSequenceUtil.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String replaceAt(CharSequence str, int index, UnaryOperator<Character> operator) {
        Character newC;
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (index < 0) {
            index += length;
        }
        String string = str.toString();
        if (index < 0 || index >= length) {
            return string;
        }
        char c = string.charAt(index);
        if (c == (newC = (Character)operator.apply(Character.valueOf(c))).charValue()) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[index] = newC.charValue();
        return new String(chars);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int codeLength(CharSequence cs) {
        return cs == null ? 0 : cs.toString().codePointCount(0, cs.length());
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (CharSequence str : strs) {
            totalLength += CharSequenceUtil.length(str);
        }
        return totalLength;
    }

    public static String limitLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return CharSequenceUtil.sub(string, 0, length) + "...";
    }

    public static String limitByteLengthUtf8(CharSequence str, int maxBytesLength, boolean appendDots) {
        return CharSequenceUtil.limitByteLength(str, CharsetUtil.UTF_8, maxBytesLength, 4, appendDots);
    }

    public static String limitByteLength(CharSequence str, Charset charset, int maxBytesLength, int factor, boolean appendDots) {
        if (str == null || str.length() * factor <= maxBytesLength) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        byte[] sba = ByteUtil.toBytes(str, charset);
        if (sba.length <= maxBytesLength) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int limitBytes = appendDots ? maxBytesLength - "...".getBytes(charset).length : maxBytesLength;
        ByteBuffer bb = ByteBuffer.wrap(sba, 0, limitBytes);
        CharBuffer cb = CharBuffer.allocate(limitBytes);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.decode(bb, cb, true);
        decoder.flush(cb);
        String result = new String(cb.array(), 0, cb.position());
        if (appendDots) {
            return result + "...";
        }
        return result;
    }

    public static <T extends CharSequence> T firstNonNull(T ... strs) {
        return (T)((CharSequence)ArrayUtil.firstNonNull(strs));
    }

    public static <T extends CharSequence> T firstNonEmpty(T ... strs) {
        return (T)ArrayUtil.firstMatch(StrValidator::isNotEmpty, strs);
    }

    public static <T extends CharSequence> T firstNonBlank(T ... strs) {
        return (T)ArrayUtil.firstMatch(StrValidator::isNotBlank, strs);
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + CharSequenceUtil.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        return CharSequenceUtil.upperAt(str, 0);
    }

    public static String upperAt(CharSequence str, int index) {
        return CharSequenceUtil.replaceAt(str, index, Character::toUpperCase);
    }

    public static String lowerFirst(CharSequence str) {
        return CharSequenceUtil.lowerAt(str, 0);
    }

    public static String lowerAt(CharSequence str, int index) {
        return CharSequenceUtil.replaceAt(str, index, Character::toLowerCase);
    }

    public static String filter(CharSequence str, Predicate<Character> predicate) {
        if (str == null || predicate == null) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!predicate.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        return NamingCase.isUpperCase(str);
    }

    public static boolean isLowerCase(CharSequence str) {
        return NamingCase.isLowerCase(str);
    }

    public static String swapCase(String str) {
        return NamingCase.swapCase(str);
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toUnderlineCase(str);
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        return NamingCase.toSymbolCase(str, symbol);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        return NamingCase.toCamelCase(name, symbol);
    }

    public static StringBuilder builder(CharSequence str) {
        return str instanceof StringBuilder ? (StringBuilder)str : new StringBuilder(str);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(isNullToEmpty ? CharSequenceUtil.toStringOrEmpty(str) : str);
        }
        return sb.toString();
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        int strLength = str.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return str.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(str.charAt(0));
            }
            case 2: {
                return str.charAt(0) + ".";
            }
            case 3: {
                return str.charAt(0) + "." + str.charAt(strLength - 1);
            }
            case 4: {
                return str.charAt(0) + ".." + str.charAt(strLength - 1);
            }
        }
        int suffixLength = (maxLength - 3) / 2;
        int preLength = suffixLength + (maxLength - 3) % 2;
        String str2 = str.toString();
        return CharSequenceUtil.format("{}...{}", str2.substring(0, preLength), str2.substring(strLength - suffixLength));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtil.join(objs, conjunction);
    }

    public static <T> String join(CharSequence conjunction, Iterable<T> iterable) {
        return CollUtil.join(iterable, conjunction);
    }

    public static boolean isNumeric(CharSequence str) {
        return CharSequenceUtil.isAllCharMatch(str, Character::isDigit);
    }

    public static String move(CharSequence str, int startInclude, int endExclude, int moveLength) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.toStringOrNull(str);
        }
        int len = str.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StringBuilder strBuilder = new StringBuilder(len);
        if (moveLength > 0) {
            int endAfterMove = Math.min(endExclude + moveLength, str.length());
            strBuilder.append(str.subSequence(0, startInclude)).append(str.subSequence(endExclude, endAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(endAfterMove, str.length()));
        } else if (moveLength < 0) {
            int startAfterMove = Math.max(startInclude + moveLength, 0);
            strBuilder.append(str.subSequence(0, startAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(startAfterMove, startInclude)).append(str.subSequence(endExclude, str.length()));
        } else {
            return CharSequenceUtil.toStringOrNull(str);
        }
        return strBuilder.toString();
    }

    public static boolean isCharEquals(CharSequence str) {
        Assert.notEmpty(str, "Str to check must be not empty!", new Object[0]);
        return CharSequenceUtil.count(str, str.charAt(0)) == str.length();
    }

    public static String normalize(CharSequence str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }

    public static String fixLength(CharSequence str, char fixedChar, int length) {
        int fixedLength = length - str.length();
        if (fixedLength <= 0) {
            return str.toString();
        }
        return str + CharSequenceUtil.repeat(fixedChar, fixedLength);
    }

    public static CharSequence commonPrefix(CharSequence str1, CharSequence str2) {
        int index;
        if (CharSequenceUtil.isEmpty(str1) || CharSequenceUtil.isEmpty(str2)) {
            return "";
        }
        int minLength = Math.min(str1.length(), str2.length());
        for (index = 0; index < minLength && str1.charAt(index) == str2.charAt(index); ++index) {
        }
        return str1.subSequence(0, index);
    }

    public static CharSequence commonSuffix(CharSequence str1, CharSequence str2) {
        if (CharSequenceUtil.isEmpty(str1) || CharSequenceUtil.isEmpty(str2)) {
            return "";
        }
        int str1Index = str1.length() - 1;
        for (int str2Index = str2.length() - 1; str1Index >= 0 && str2Index >= 0 && str1.charAt(str1Index) == str2.charAt(str2Index); --str1Index, --str2Index) {
        }
        return str1.subSequence(str1Index + 1, str1.length());
    }

    public static int[] toChars(CharSequence str, boolean isCodePoint) {
        if (null == str) {
            return null;
        }
        return (isCodePoint ? str.codePoints() : str.chars()).toArray();
    }
}

