/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.pool.ObjectFactory;
import org.dromara.hutool.core.pool.ObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionPoolConfig;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.ds.pooled.PooledConnection;
import org.dromara.hutool.db.ds.simple.AbstractDataSource;
import org.dromara.hutool.setting.props.Props;

public class PooledDataSource
extends AbstractDataSource {
    private static final String KEY_MAX_WAIT = "maxWait";
    private static final String KEY_INITIAL_SIZE = "initialSize";
    private static final String KEY_MAX_ACTIVE = "maxActive";
    protected Driver driver;
    private final int maxWait;
    private final ObjectPool<Connection> connPool;

    public PooledDataSource(ConnectionConfig<?> config) {
        String driverName = config.getDriver();
        if (StrUtil.isNotBlank(driverName)) {
            this.driver = DriverUtil.createDriver(driverName);
        }
        Props poolProps = Props.of(config.getPoolProps());
        this.maxWait = poolProps.getInt(KEY_MAX_WAIT, 6000);
        PartitionPoolConfig poolConfig = (PartitionPoolConfig)PartitionPoolConfig.of().setPartitionSize(1).setMaxWait(this.maxWait).setMinSize(poolProps.getInt(KEY_INITIAL_SIZE, 0)).setMaxSize(poolProps.getInt(KEY_MAX_ACTIVE, 8));
        this.connPool = new PartitionObjectPool<Connection>(poolConfig, this.createConnFactory(config));
    }

    public PooledDataSource setDriver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.connPool.borrowObject());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(this.connPool);
    }

    public void returnObject(PooledConnection conn) {
        this.connPool.returnObject(conn);
    }

    private ObjectFactory<Connection> createConnFactory(final ConnectionConfig<?> config) {
        return new ObjectFactory<Connection>(){

            @Override
            public Connection create() {
                return new PooledConnection(config, PooledDataSource.this);
            }

            @Override
            public boolean validate(Connection connection) {
                try {
                    return null != connection && connection.isValid(PooledDataSource.this.maxWait);
                }
                catch (SQLException e) {
                    throw new DbException(e);
                }
            }

            @Override
            public void destroy(Connection connection) {
                IoUtil.closeQuietly(connection);
            }
        };
    }
}

