/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.simple;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.simple.AbstractDataSource;
import org.dromara.hutool.setting.props.Props;

public class SimpleDataSource
extends AbstractDataSource {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private final ConnectionConfig<?> config;

    public SimpleDataSource(ConnectionConfig<?> config) {
        this.config = config;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Properties connProps;
        String pass;
        ConnectionConfig<?> config = this.config;
        Props info = new Props();
        String user = config.getUser();
        if (user != null) {
            info.setProperty("user", user);
        }
        if ((pass = config.getPass()) != null) {
            info.setProperty("password", pass);
        }
        if (MapUtil.isNotEmpty(connProps = config.getConnProps())) {
            info.putAll((Map<?, ?>)connProps);
        }
        return DriverManager.getConnection(config.getUrl(), info);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.config.getUrl(), username, password);
    }

    @Override
    public void close() {
    }
}

