/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.sql.BoundSql;
import org.dromara.hutool.db.sql.NamedSql;
import org.dromara.hutool.db.sql.StatementWrapper;
import org.dromara.hutool.db.sql.filter.SqlFilter;

public class StatementBuilder
implements Builder<StatementWrapper> {
    private static final long serialVersionUID = 1L;
    private final BoundSql boundSql = new BoundSql();
    private Connection connection;
    private boolean returnGeneratedKey = true;
    private SqlFilter sqlFilter;

    public static StatementBuilder of() {
        return new StatementBuilder();
    }

    public StatementBuilder setSqlFilter(SqlFilter sqlFilter) {
        this.sqlFilter = sqlFilter;
        return this;
    }

    public StatementBuilder setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public StatementBuilder setSql(String sql) {
        this.boundSql.setSql(sql);
        return this;
    }

    public StatementBuilder setParams(Object ... params) {
        this.boundSql.setParams(ListUtil.of(params));
        return this;
    }

    public StatementBuilder setParamList(List<Object> params) {
        this.boundSql.setParams(params);
        return this;
    }

    public StatementBuilder setReturnGeneratedKey(boolean returnGeneratedKey) {
        this.returnGeneratedKey = returnGeneratedKey;
        return this;
    }

    @Override
    public StatementWrapper build() {
        try {
            return this._build();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public StatementWrapper buildForBatch() throws DbException {
        StatementWrapper ps;
        String sql = this.boundSql.getSql();
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        List<Object> paramsBatch = this.boundSql.getParams();
        if (null != this.sqlFilter) {
            this.sqlFilter.filter(this.connection, this.boundSql, this.returnGeneratedKey);
        }
        try {
            ps = StatementWrapper.of(this.connection.prepareStatement(sql));
            HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
            Set keys = null;
            for (Object params : paramsBatch) {
                if (null == params) continue;
                if (ArrayUtil.isArray(params)) {
                    ps.fillParams(new ArrayIter(params), nullTypeMap);
                } else if (params instanceof Entity) {
                    Entity entity = (Entity)params;
                    if (null == keys) {
                        keys = entity.keySet();
                        ps.fillParams(entity.values(), nullTypeMap);
                    } else {
                        ps.fillParams(MapUtil.valuesOfKeys(entity, keys), nullTypeMap);
                    }
                }
                ps.addBatch();
            }
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        return ps;
    }

    public CallableStatement buildForCall() {
        String sql = this.boundSql.getSql();
        Object[] params = this.boundSql.getParamArray();
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        if (null != this.sqlFilter) {
            this.sqlFilter.filter(this.connection, this.boundSql, this.returnGeneratedKey);
        }
        try {
            return (CallableStatement)StatementWrapper.of(this.connection.prepareCall(sql)).fillArrayParam(params).getRaw();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    private StatementWrapper _build() throws SQLException {
        String sql = this.boundSql.getSql();
        Object[] params = this.boundSql.getParamArray();
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        if (ArrayUtil.isNotEmpty(params) && 1 == params.length && params[0] instanceof Map) {
            NamedSql namedSql = new NamedSql(sql, Convert.toMap(String.class, Object.class, params[0]));
            sql = namedSql.getSql();
            params = namedSql.getParamArray();
        }
        if (null != this.sqlFilter) {
            this.sqlFilter.filter(this.connection, this.boundSql, this.returnGeneratedKey);
        }
        PreparedStatement ps = this.returnGeneratedKey && StrUtil.startWithIgnoreCase(sql, "insert") ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
        return StatementWrapper.of(ps).fillArrayParam(params);
    }
}

