/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.resource.FileResource;
import org.dromara.hutool.core.io.resource.MultiFileResource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.TableMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.client.body.HttpBody;

public abstract class FormBody<T extends FormBody<T>>
implements HttpBody {
    protected Map<String, Object> form;
    protected final Charset charset;

    protected FormBody(Map<String, Object> form, Charset charset) {
        this.form = form;
        this.charset = charset;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public T form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            formMap.forEach(this::form);
        }
        return (T)this;
    }

    public T form(String name, Object value) {
        String strValue;
        if (StrUtil.isBlank(name)) {
            return (T)this;
        }
        if (ObjUtil.isNull(value)) {
            this.form.remove(name);
        }
        if (value instanceof File) {
            return this.putToForm(name, new FileResource((File)value));
        }
        if (value instanceof Path) {
            return this.putToForm(name, new FileResource((Path)value));
        }
        if (value instanceof Iterable) {
            strValue = CollUtil.join((Iterable)value, ",");
        } else if (ArrayUtil.isArray(value)) {
            Class<?> componentType = ArrayUtil.getComponentType(value);
            if (File.class == componentType) {
                return this.putToForm(name, new MultiFileResource((File[])value));
            }
            if (Path.class == componentType) {
                return this.putToForm(name, new MultiFileResource((Path[])value));
            }
            strValue = ArrayUtil.join(value, (CharSequence)",");
        } else {
            strValue = Convert.toStr(value, null);
        }
        return this.putToForm(name, strValue);
    }

    private T putToForm(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.form) {
                this.form = new TableMap<String, Object>(16);
            }
            this.form.put(name, value);
        }
        return (T)this;
    }
}

