/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.CaseInsensitiveLinkedMap;
import org.dromara.hutool.core.map.CaseInsensitiveTreeMap;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONTokener;
import org.dromara.hutool.json.serialize.GlobalSerializeMapping;
import org.dromara.hutool.json.serialize.JSONDeserializer;
import org.dromara.hutool.json.serialize.JSONStringer;

public final class InternalJSONUtil {
    public static Object parseValueFromString(String string) {
        if (StrUtil.isEmpty(string) || "null".equalsIgnoreCase(string)) {
            return null;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null) {
            return "null";
        }
        if (value instanceof JSONStringer) {
            try {
                return ((JSONStringer)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject((Object)map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray(coll).toString();
        }
        if (ArrayUtil.isArray(value)) {
            return new JSONArray(value).toString();
        }
        return InternalJSONUtil.quote(value.toString());
    }

    public static void propertyPut(JSONObject jsonObject, Object key, Object value, Predicate<MutableEntry<String, Object>> predicate) {
        String[] path = SplitUtil.splitToArray(Convert.toStr(key), ".");
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.config());
                target.set(segment, nextTarget, predicate);
            }
            target = nextTarget;
        }
        target.set(path[last], value, predicate);
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        return !(obj instanceof CharSequence) && !(obj instanceof JSONTokener) && !(obj instanceof Map);
    }

    public static CopyOptions toCopyOptions(JSONConfig config) {
        return CopyOptions.of().setIgnoreCase(config.isIgnoreCase()).setIgnoreError(config.isIgnoreError()).setIgnoreNullValue(config.isIgnoreNullValue()).setTransientSupport(config.isTransientSupport()).setConverter(config.getConverter());
    }

    public static String quote(CharSequence string) {
        return InternalJSONUtil.quote(string, true);
    }

    public static String quote(CharSequence string, boolean isWrap) {
        return InternalJSONUtil.quote(string, new StringWriter(), isWrap).toString();
    }

    public static void quote(CharSequence str, Writer writer) throws IORuntimeException {
        InternalJSONUtil.quote(str, writer, true);
    }

    public static Writer quote(CharSequence str, Writer writer, boolean isWrap) throws IORuntimeException {
        try {
            return InternalJSONUtil._quote(str, writer, isWrap);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String escape(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            builder.append(InternalJSONUtil.escape(c));
        }
        return builder.toString();
    }

    static Map<String, Object> createRawMap(int capacity, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.of();
        }
        Comparator<String> keyComparator = config.getKeyComparator();
        Map rawHashMap = config.isIgnoreCase() ? (null != keyComparator ? new CaseInsensitiveTreeMap(keyComparator) : new CaseInsensitiveLinkedMap(capacity)) : (null != keyComparator ? new TreeMap(keyComparator) : new LinkedHashMap(capacity));
        return rawHashMap;
    }

    public static <T> JSONDeserializer<T> getDeserializer(Type targetType) {
        Class<?> rawType = TypeUtil.getClass(targetType);
        if (null != rawType && JSONDeserializer.class.isAssignableFrom(rawType)) {
            return (JSONDeserializer)ConstructorUtil.newInstanceIfPossible(rawType);
        }
        return GlobalSerializeMapping.getDeserializer(targetType);
    }

    private static Writer _quote(CharSequence str, Writer writer, boolean isWrap) throws IOException {
        if (StrUtil.isEmpty(str)) {
            if (isWrap) {
                writer.write("\"\"");
            }
            return writer;
        }
        int len = str.length();
        if (isWrap) {
            writer.write(34);
        }
        block3: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write("\\");
                    writer.write(c);
                    continue block3;
                }
                default: {
                    writer.write(InternalJSONUtil.escape(c));
                }
            }
        }
        if (isWrap) {
            writer.write(34);
        }
        return writer;
    }

    private static String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
            return HexUtil.toUnicodeHex(c);
        }
        return Character.toString(c);
    }
}

