/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.convert.impl.ArrayConverter;
import org.dromara.hutool.core.lang.Validator;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.lang.mutable.MutableObj;
import org.dromara.hutool.core.text.StrJoiner;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONGetter;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONObjectIter;
import org.dromara.hutool.json.mapper.JSONArrayMapper;
import org.dromara.hutool.json.mapper.JSONValueMapper;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONArray
implements JSON,
JSONGetter<Integer>,
List<Object>,
RandomAccess {
    private static final long serialVersionUID = 2664900568717612292L;
    public static final int DEFAULT_CAPACITY = 10;
    private List<Object> rawList;
    private JSONConfig config;
    private JSONValueMapper valueMapper;

    public JSONArray() {
        this(10);
    }

    public JSONArray(int initialCapacity) {
        this(initialCapacity, JSONConfig.of());
    }

    public JSONArray(JSONConfig config) {
        this(10, config);
    }

    public JSONArray(int initialCapacity, JSONConfig config) {
        this.rawList = new ArrayList<Object>(initialCapacity);
        this.config = ObjUtil.defaultIfNull(config, JSONConfig::of);
        this.valueMapper = JSONValueMapper.of(this.config);
    }

    public JSONArray(Object object) throws JSONException {
        this(object, JSONConfig.of());
    }

    public JSONArray(Object object, JSONConfig jsonConfig) throws JSONException {
        this(object, jsonConfig, null);
    }

    public JSONArray(Object object, JSONConfig jsonConfig, Predicate<Mutable<Object>> predicate) throws JSONException {
        this(10, jsonConfig);
        JSONArrayMapper.of(object, predicate).mapTo(this);
    }

    @Override
    public JSONConfig config() {
        return this.config;
    }

    public JSONArray setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public String join(String separator) throws JSONException {
        return StrJoiner.of(separator).append(this, InternalJSONUtil::valueToString).toString();
    }

    @Override
    public Object get(int index) {
        return this.rawList.get(index);
    }

    @Override
    public Object getObj(Integer index, Object defaultValue) {
        return index < 0 || index >= this.size() ? defaultValue : this.rawList.get(index);
    }

    public JSONArray put(Object value) {
        return this.set(value);
    }

    public JSONArray set(Object value) {
        this.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) throws JSONException {
        this.set(index, value);
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject(this.config);
        for (int i = 0; i < names.size(); ++i) {
            jo.set(names.getStr(i), this.getObj(i));
        }
        return jo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawList == null ? 0 : this.rawList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (this.rawList == null) {
            return other.rawList == null;
        }
        return this.rawList.equals(other.rawList);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawList.iterator();
    }

    public Iterable<JSONObject> jsonIter() {
        return new JSONObjectIter(this.iterator());
    }

    @Override
    public int size() {
        return this.rawList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.rawList.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.rawList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return (Object[])ArrayConverter.INSTANCE.convert(a.getClass().getComponentType(), this);
    }

    @Override
    public boolean add(Object e) {
        return this.add(e, null);
    }

    public boolean add(Object e, Predicate<Mutable<Object>> predicate) {
        return this.addRaw(this.valueMapper.map(e), predicate);
    }

    @Override
    public Object remove(int index) {
        return index >= 0 && index < this.size() ? this.rawList.remove(index) : null;
    }

    @Override
    public boolean remove(Object o) {
        return this.rawList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rawList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        for (Object obj : c) {
            this.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object object : c) {
            if (null == object && this.config.isIgnoreNullValue()) continue;
            this.add((Object)index);
            list.add(this.valueMapper.map(object));
        }
        return this.rawList.addAll(index, list);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rawList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rawList.retainAll(c);
    }

    @Override
    public void clear() {
        this.rawList.clear();
    }

    @Override
    public Object set(int index, Object element) {
        return this.set(index, element, null);
    }

    public Object set(int index, Object element, Predicate<MutableEntry<Integer, Object>> filter) {
        MutableEntry<Integer, Object> pair;
        if (null != filter && filter.test(pair = new MutableEntry<Integer, Object>(index, element))) {
            element = pair.getValue();
        }
        if (index >= this.size()) {
            this.add(index, element);
            return null;
        }
        if (null == element && this.config.isIgnoreNullValue()) {
            return null;
        }
        return this.rawList.set(index, this.valueMapper.map(element));
    }

    @Override
    public void add(int index, Object element) {
        if (null == element && this.config.isIgnoreNullValue()) {
            return;
        }
        if (index < this.size()) {
            if (index < 0) {
                index = 0;
            }
            this.rawList.add(index, this.valueMapper.map(element));
        } else {
            if (!this.config.isIgnoreNullValue()) {
                Validator.checkIndexLimit(index, (this.size() + 1) * 10);
                while (index != this.size()) {
                    this.add((Object)null);
                }
            }
            this.add(element);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.rawList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rawList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.rawList.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.rawList.subList(fromIndex, toIndex);
    }

    public Object toArray(Class<?> arrayClass) {
        return ArrayConverter.INSTANCE.convert(arrayClass, this);
    }

    public <T> List<T> toList(Class<T> elementType) {
        return Convert.toList(elementType, this);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(int indentFactor, Predicate<MutableEntry<Object, Object>> predicate) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0, predicate).toString();
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent, Predicate<MutableEntry<Object, Object>> predicate) throws JSONException {
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, indent, this.config).beginArray();
        CollUtil.forEach(this, (value, index) -> jsonWriter.writeField(new MutableEntry<Object, Object>(index, value), predicate));
        jsonWriter.end();
        return writer;
    }

    public Object clone() throws CloneNotSupportedException {
        JSONArray clone = (JSONArray)super.clone();
        clone.config = this.config;
        clone.valueMapper = this.valueMapper;
        clone.rawList = ObjUtil.clone(this.rawList);
        return clone;
    }

    protected boolean addRaw(Object obj, Predicate<Mutable<Object>> predicate) {
        if (null != predicate) {
            MutableObj<Object> mutable = new MutableObj<Object>(obj);
            if (predicate.test(mutable)) {
                obj = mutable.get();
            } else {
                return false;
            }
        }
        if (null == obj && this.config.isIgnoreNullValue()) {
            return false;
        }
        return this.rawList.add(obj);
    }
}

