/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.JSONEngine;

public class GsonEngine
implements JSONEngine {
    private final Gson gson = new GsonBuilder().create();

    @Override
    public void serialize(Object bean, Writer writer) {
        this.gson.toJson(bean, (Appendable)writer);
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        if (type instanceof Class) {
            return (T)this.gson.fromJson(reader, (Class)type);
        }
        if (type instanceof Type) {
            return (T)this.gson.fromJson(reader, (Type)type);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }
}

