/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.JSONEngine;

public class JSONEngineFactory {
    public static JSONEngine getEngine() {
        return Singleton.get(JSONEngine.class.getName(), JSONEngineFactory::createEngine);
    }

    public static JSONEngine createEngine(String engineName) throws JSONException {
        if (!StrUtil.endWithIgnoreCase(engineName, "Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader<JSONEngine> list = SpiUtil.loadList(JSONEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase(serviceName, engineName)) continue;
            return list.getService(serviceName);
        }
        throw new JSONException("No such engine named: " + engineName);
    }

    public static JSONEngine createEngine() {
        return SpiUtil.loadFirstAvailable(JSONEngine.class);
    }
}

