/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.writer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.json.writer.BooleanValueWriter;
import org.dromara.hutool.json.writer.ClassValueWriter;
import org.dromara.hutool.json.writer.DateValueWriter;
import org.dromara.hutool.json.writer.JSONStringValueWriter;
import org.dromara.hutool.json.writer.JSONValueWriter;
import org.dromara.hutool.json.writer.JdkValueWriter;
import org.dromara.hutool.json.writer.NumberValueWriter;

public class GlobalValueWriters {
    private static final List<JSONValueWriter> valueWriterList = Collections.synchronizedList(new LinkedList());

    public static void add(JSONValueWriter valueWriter) {
        valueWriterList.add(0, Assert.notNull(valueWriter));
    }

    public static JSONValueWriter get(Object value) {
        if (value instanceof JSONValueWriter) {
            return (JSONValueWriter)value;
        }
        return valueWriterList.stream().filter(writer -> writer.test(value)).findFirst().orElse(null);
    }

    static {
        valueWriterList.add(NumberValueWriter.INSTANCE);
        valueWriterList.add(DateValueWriter.INSTANCE);
        valueWriterList.add(BooleanValueWriter.INSTANCE);
        valueWriterList.add(JSONStringValueWriter.INSTANCE);
        valueWriterList.add(ClassValueWriter.INSTANCE);
        valueWriterList.add(JdkValueWriter.INSTANCE);
    }
}

