/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation.elements;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.dromara.hutool.core.annotation.AnnotationMapping;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.stream.EasyStream;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class MetaAnnotatedElement<T extends AnnotationMapping<Annotation>>
implements AnnotatedElement,
Iterable<T> {
    private final AnnotatedElement element;
    private final BiFunction<T, Annotation, T> mappingFactory;
    private volatile Map<Class<? extends Annotation>, T> annotationMappings;

    public static <A extends AnnotationMapping<Annotation>> MetaAnnotatedElement<A> create(AnnotatedElement element, BiFunction<A, Annotation, A> mappingFactory) {
        return new MetaAnnotatedElement<A>(element, mappingFactory);
    }

    public MetaAnnotatedElement(AnnotatedElement element, BiFunction<T, Annotation, T> mappingFactory) {
        this.element = Objects.requireNonNull(element);
        this.mappingFactory = Objects.requireNonNull(mappingFactory);
        this.annotationMappings = null;
    }

    public Optional<T> getMapping(Class<? extends Annotation> annotationType) {
        return Optional.ofNullable(annotationType).map(this.getAnnotationMappings()::get);
    }

    public AnnotatedElement getElement() {
        return this.element;
    }

    public Optional<T> getDeclaredMapping(Class<? extends Annotation> annotationType) {
        return ((EasyStream)EasyStream.of(this.getAnnotationMappings().values()).filter(AnnotationMapping::isRoot)).findFirst(mapping -> ObjUtil.equals(annotationType, mapping.annotationType()));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getMapping(annotationType).isPresent();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.getMapping(annotationType).map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).orElse(null));
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.getDeclaredMapping(annotationType).map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).orElse(null));
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        A result = this.getAnnotation(annotationType);
        if (Objects.nonNull(result)) {
            return new Annotation[]{result};
        }
        return (Annotation[])ArrayUtil.newArray(annotationType, 0);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationType) {
        A result = this.getDeclaredAnnotation(annotationType);
        if (Objects.nonNull(result)) {
            return new Annotation[]{result};
        }
        return (Annotation[])ArrayUtil.newArray(annotationType, 0);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.getAnnotationMappings().values().stream().filter(AnnotationMapping::isRoot).map(AnnotationMapping::getResolvedAnnotation).toArray(Annotation[]::new);
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.getAnnotationMappings().values().stream().map(AnnotationMapping::getResolvedAnnotation).toArray(Annotation[]::new);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAnnotationMappings().values().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaAnnotatedElement that = (MetaAnnotatedElement)o;
        return this.element.equals(that.element) && this.mappingFactory.equals(that.mappingFactory);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.mappingFactory);
    }

    protected final Map<Class<? extends Annotation>, T> getAnnotationMappings() {
        this.initAnnotationMappingsIfNecessary();
        return this.annotationMappings;
    }

    protected boolean isNeedMapping(Map<Class<? extends Annotation>, T> mappings, Annotation annotation) {
        return !CharSequenceUtil.startWith((CharSequence)annotation.annotationType().getName(), "java.lang.") && !mappings.containsKey(annotation.annotationType());
    }

    private T createMapping(T source, Annotation annotation) {
        return (T)((AnnotationMapping)this.mappingFactory.apply(source, annotation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAnnotationMappingsIfNecessary() {
        if (Objects.isNull(this.annotationMappings)) {
            MetaAnnotatedElement metaAnnotatedElement = this;
            synchronized (metaAnnotatedElement) {
                if (Objects.isNull(this.annotationMappings)) {
                    LinkedHashMap mappings = new LinkedHashMap(8);
                    this.initAnnotationMappings(mappings);
                    this.annotationMappings = Collections.unmodifiableMap(mappings);
                }
            }
        }
    }

    private void initAnnotationMappings(Map<Class<? extends Annotation>, T> mappings) {
        LinkedList<AnnotationMapping> deque = new LinkedList<AnnotationMapping>();
        Arrays.stream(AnnotationUtil.getDeclaredAnnotations(this.element)).filter(m -> this.isNeedMapping((Map<Class<? extends Annotation>, T>)mappings, (Annotation)m)).map(annotation -> this.createMapping(null, (Annotation)annotation)).filter(Objects::nonNull).forEach(deque::addLast);
        while (!deque.isEmpty()) {
            AnnotationMapping mapping = (AnnotationMapping)deque.removeFirst();
            if (!this.isNeedMapping(mappings, mapping)) continue;
            mappings.put(mapping.annotationType(), mapping);
            for (Annotation annotation2 : AnnotationUtil.getDeclaredAnnotations(mapping.annotationType())) {
                AnnotationMapping m2;
                if (mappings.containsKey(annotation2.annotationType()) || !Objects.nonNull(m2 = this.createMapping(mapping, annotation2)) || !this.isNeedMapping(mappings, m2)) continue;
                deque.addLast(m2);
            }
        }
    }
}

