/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.annotation.PropIgnore;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.reflect.FieldInvoker;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.Invoker;
import org.dromara.hutool.core.reflect.ModifierType;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodInvoker;

public class PropDesc {
    private Invoker fieldInvoker;
    private final String fieldName;
    protected Invoker getter;
    protected Invoker setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this(FieldUtil.getFieldName(field), getter, setter);
        this.fieldInvoker = null == field ? null : FieldInvoker.of(field);
    }

    public PropDesc(String fieldName, Method getterMethod, Method setterMethod) {
        this.fieldName = fieldName;
        this.getter = null == getterMethod ? null : MethodInvoker.of(getterMethod);
        this.setter = null == setterMethod ? null : MethodInvoker.of(setterMethod);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getRawFieldName() {
        if (null == this.fieldInvoker) {
            return this.fieldName;
        }
        return this.fieldInvoker.getName();
    }

    public Field getField() {
        if (null != this.fieldInvoker && this.fieldInvoker instanceof FieldInvoker) {
            return ((FieldInvoker)this.fieldInvoker).getField();
        }
        return null;
    }

    public Type getFieldType() {
        if (null != this.fieldInvoker) {
            return this.fieldInvoker.getType();
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.fieldInvoker) {
            return this.fieldInvoker.getTypeClass();
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Invoker getGetter() {
        return this.getter;
    }

    public Invoker getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        Field field = null;
        if (this.fieldInvoker instanceof FieldInvoker) {
            field = ((FieldInvoker)this.fieldInvoker).getField();
        }
        Method getterMethod = null;
        if (this.getter instanceof MethodInvoker) {
            getterMethod = ((MethodInvoker)this.getter).getMethod();
        }
        if (checkTransient && PropDesc.isTransientForGet(field, getterMethod)) {
            return false;
        }
        if (PropDesc.isIgnoreGet(field, getterMethod)) {
            return false;
        }
        return null != getterMethod || ModifierUtil.isPublic(field);
    }

    public Object getValue(Object bean, boolean ignoreError) {
        block4: {
            try {
                if (null != this.getter) {
                    return this.getter.invoke(bean, new Object[0]);
                }
                if (null != this.fieldInvoker) {
                    return this.fieldInvoker.invoke(bean, new Object[0]);
                }
            }
            catch (Exception e) {
                if (ignoreError) break block4;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result = this.getValue(bean, ignoreError);
        if (null != result && null != targetType) {
            return ConvertUtil.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        Field field = null;
        if (this.fieldInvoker instanceof FieldInvoker) {
            field = ((FieldInvoker)this.fieldInvoker).getField();
        }
        Method setterMethod = null;
        if (this.setter instanceof MethodInvoker) {
            setterMethod = ((MethodInvoker)this.setter).getMethod();
        }
        if (checkTransient && PropDesc.isTransientForSet(field, setterMethod)) {
            return false;
        }
        if (PropDesc.isIgnoreSet(field, setterMethod)) {
            return false;
        }
        return null != setterMethod || ModifierUtil.isPublic(field);
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            this.setter.invoke(bean, value);
        } else if (null != this.fieldInvoker) {
            this.fieldInvoker.invoke(bean, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean, ignoreError)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = ConvertUtil.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    public String toString() {
        return "PropDesc{field=" + this.fieldInvoker + ", fieldName=" + this.fieldName + ", getter=" + this.getter + ", setter=" + this.setter + '}';
    }

    private Type findPropType(Invoker getterInvoker, Invoker setterInvoker) {
        Type type = null;
        if (null != getterInvoker) {
            type = getterInvoker.getType();
        }
        if (null == type && null != setterInvoker) {
            type = setterInvoker.getType();
        }
        return type;
    }

    private Class<?> findPropClass(Invoker getterInvoker, Invoker setterInvoker) {
        Class<?> type = null;
        if (null != getterInvoker) {
            type = getterInvoker.getTypeClass();
        }
        if (null == type && null != setterInvoker) {
            type = setterInvoker.getTypeClass();
        }
        return type;
    }

    private static boolean isIgnoreGet(Field field, Method getterMethod) {
        return AnnotationUtil.hasAnnotation(field, PropIgnore.class) || AnnotationUtil.hasAnnotation(getterMethod, PropIgnore.class);
    }

    private static boolean isIgnoreSet(Field field, Method setterMethod) {
        return AnnotationUtil.hasAnnotation(field, PropIgnore.class) || AnnotationUtil.hasAnnotation(setterMethod, PropIgnore.class);
    }

    private static boolean isTransientForGet(Field field, Method getterMethod) {
        boolean isTransient = ModifierUtil.hasAny(field, ModifierType.TRANSIENT);
        if (!isTransient && null != getterMethod && !(isTransient = ModifierUtil.hasAny(getterMethod, ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(getterMethod, Transient.class);
        }
        return isTransient;
    }

    private static boolean isTransientForSet(Field field, Method setterMethod) {
        boolean isTransient = ModifierUtil.hasAny(field, ModifierType.TRANSIENT);
        if (!isTransient && null != setterMethod && !(isTransient = ModifierUtil.hasAny(setterMethod, ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(setterMethod, Transient.class);
        }
        return isTransient;
    }
}

