/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.io.SerializeUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ByteUtil;

public class ArrayConverter
extends AbstractConverter
implements MatcherConverter {
    private static final long serialVersionUID = 1L;
    public static final ArrayConverter INSTANCE = new ArrayConverter();
    private boolean ignoreElementError;

    public ArrayConverter() {
        this(false);
    }

    public ArrayConverter(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return rawType.isArray();
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        Class<?> targetComponentType = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
        return value.getClass().isArray() ? this.convertArrayToArray(targetComponentType, value) : this.convertObjectToArray(targetComponentType, value);
    }

    public void setIgnoreElementError(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    private Object convertArrayToArray(Class<?> targetComponentType, Object array) {
        Class<?> valueComponentType = ArrayUtil.getComponentType(array);
        if (valueComponentType == targetComponentType) {
            return array;
        }
        int len = ArrayUtil.length(array);
        Object result = Array.newInstance(targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Class<?> targetComponentType, Object value) {
        if (value instanceof CharSequence) {
            if (targetComponentType == Character.TYPE || targetComponentType == Character.class) {
                return this.convertArrayToArray(targetComponentType, value.toString().toCharArray());
            }
            if (targetComponentType == Byte.TYPE) {
                String str = value.toString();
                if (Base64.isTypeBase64(str)) {
                    return Base64.decode(value.toString());
                }
                return str.getBytes();
            }
            String[] strings = SplitUtil.splitToArray(value.toString(), ",");
            return this.convertArrayToArray(targetComponentType, strings);
        }
        if (value instanceof Iterator) {
            value = IterUtil.asIterable((Iterator)((Object)value));
        }
        Object result = value instanceof Iterable ? this.convertIterableToArray(targetComponentType, value) : (value instanceof Number && Byte.TYPE == targetComponentType ? (Object)ByteUtil.toBytes((Number)((Object)value)) : (value instanceof Serializable && Byte.TYPE == targetComponentType ? (Object)SerializeUtil.serialize(value) : this.convertToSingleElementArray(targetComponentType, value)));
        return result;
    }

    private Object convertIterableToArray(Class<?> targetComponentType, Iterable<?> value) {
        Object result;
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            result = Array.newInstance(targetComponentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(targetComponentType, element));
                ++i;
            }
        } else {
            ArrayList<?> list = ListUtil.of(value);
            int size = list.size();
            result = Array.newInstance(targetComponentType, size);
            for (int i = 0; i < size; ++i) {
                Array.set(result, i, this.convertComponentType(targetComponentType, list.get(i)));
            }
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Class<?> targetComponentType, Object value) {
        Object[] singleElementArray = ArrayUtil.newArray(targetComponentType, 1);
        singleElementArray[0] = this.convertComponentType(targetComponentType, value);
        return singleElementArray;
    }

    private Object convertComponentType(Class<?> targetComponentType, Object value) {
        return ConvertUtil.convertWithCheck(targetComponentType, value, null, this.ignoreElementError);
    }
}

