/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.ConverterWithRoot;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class PairConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;

    public PairConverter(Converter rootConverter) {
        super(rootConverter);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeUtil.getTypeArgument(targetType, 0);
        Type rightType = TypeUtil.getTypeArgument(targetType, 1);
        return this.convert(leftType, rightType, value);
    }

    public Pair<?, ?> convert(Type leftType, Type rightType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = MapUtil.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = MapUtil.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = PairConverter.strToMap(str);
        } else if (BeanUtil.isReadableBean(value.getClass())) {
            map = BeanUtil.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToPair(leftType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = StrUtil.indexOf(str, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, str.length());
        if (index > -1) {
            return MapUtil.of(str.subSequence(0, index), str.subSequence(index + 1, str.length()));
        }
        return null;
    }

    private Pair<?, ?> mapToPair(Type keyType, Type valueType, Map map) {
        Object right;
        Object left;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            left = entry.getKey();
            right = entry.getValue();
        } else {
            left = map.get("left");
            right = map.get("right");
        }
        return Pair.of(TypeUtil.isUnknown(keyType) ? left : this.rootConverter.convert(keyType, left), TypeUtil.isUnknown(valueType) ? right : this.rootConverter.convert(valueType, right));
    }
}

