/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.unit;

import java.text.DecimalFormat;
import org.dromara.hutool.core.io.unit.DataSize;
import org.dromara.hutool.core.io.unit.DataUnit;
import org.dromara.hutool.core.text.StrUtil;

public class DataSizeUtil {
    public static long parse(String text) {
        return DataSize.parse(text).toBytes();
    }

    public static String format(long size) {
        return DataSizeUtil.format(size, false);
    }

    public static String format(long size, boolean useSimpleName) {
        return DataSizeUtil.format(size, 2, useSimpleName ? DataUnit.UNIT_NAMES_SIMPLE : DataUnit.UNIT_NAMES, " ");
    }

    public static String format(long size, int scale, String[] unitNames, String delimiter) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = Math.min(unitNames.length - 1, (int)(Math.log10(size) / Math.log10(1024.0)));
        return new DecimalFormat("#,##0." + StrUtil.repeat('#', scale)).format((double)size / Math.pow(1024.0, digitGroups)) + delimiter + unitNames[digitGroups];
    }
}

