/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.math;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.ChineseNumberParser;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ChineseNumberFormatter {
    static final char[] DIGITS = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private boolean useTraditional;
    private boolean moneyMode;
    private boolean colloquialMode;
    private String negativeName = "\u8d1f";
    private String unitName = "\u5143";

    public static String formatSimple(long amount) {
        if (amount < 10000L && amount > -10000L) {
            return String.valueOf(amount);
        }
        String res = amount < 100000000L && amount > -100000000L ? NumberUtil.div(amount, 10000, 2) + "\u4e07" : (amount < 1000000000000L && amount > -1000000000000L ? NumberUtil.div(amount, 100000000, 2) + "\u4ebf" : NumberUtil.div(amount, 1000000000000L, 2) + "\u4e07\u4ebf");
        return res;
    }

    public static char formatChar(char c, boolean isUseTraditional) {
        if (c < '0' || c > '9') {
            return c;
        }
        return ChineseNumberFormatter.numberToChinese(c - 48, isUseTraditional);
    }

    public static ChineseNumberFormatter of() {
        return new ChineseNumberFormatter();
    }

    public ChineseNumberFormatter setUseTraditional(boolean useTraditional) {
        this.useTraditional = useTraditional;
        return this;
    }

    public ChineseNumberFormatter setMoneyMode(boolean moneyMode) {
        this.moneyMode = moneyMode;
        return this;
    }

    public ChineseNumberFormatter setColloquialMode(boolean colloquialMode) {
        this.colloquialMode = colloquialMode;
        return this;
    }

    public ChineseNumberFormatter setNegativeName(String negativeName) {
        this.negativeName = Assert.notNull(negativeName);
        return this;
    }

    public ChineseNumberFormatter setUnitName(String unitName) {
        this.unitName = Assert.notNull(unitName);
        return this;
    }

    public String format(double amount) {
        if (0.0 == amount) {
            return this.moneyMode ? "\u96f6\u5143\u6574" : "\u96f6";
        }
        Assert.checkBetween(amount, -9.999999999999998E13, 9.999999999999998E13, "Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01", new Object[0]);
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0.0) {
            chineseStr.append(this.negativeName);
            amount = -amount;
        }
        long yuan = Math.round(amount * 100.0);
        int fen = (int)(yuan % 10L);
        int jiao = (int)((yuan /= 10L) % 10L);
        boolean isMoneyMode = this.moneyMode;
        if (!isMoneyMode || 0L != (yuan /= 10L)) {
            chineseStr.append(this.longToChinese(yuan));
            if (isMoneyMode) {
                chineseStr.append(this.unitName);
            }
        }
        if (0 == jiao && 0 == fen) {
            if (isMoneyMode) {
                chineseStr.append("\u6574");
            }
            return chineseStr.toString();
        }
        if (!isMoneyMode) {
            chineseStr.append("\u70b9");
        }
        if (0L == yuan && 0 == jiao) {
            if (!isMoneyMode) {
                chineseStr.append("\u96f6");
            }
        } else {
            chineseStr.append(ChineseNumberFormatter.numberToChinese(jiao, this.useTraditional));
            if (isMoneyMode && 0 != jiao) {
                chineseStr.append("\u89d2");
            }
        }
        if (0 != fen) {
            chineseStr.append(ChineseNumberFormatter.numberToChinese(fen, this.useTraditional));
            if (isMoneyMode) {
                chineseStr.append("\u5206");
            }
        }
        return chineseStr.toString();
    }

    private String longToChinese(long amount) {
        String partChinese;
        if (0L == amount) {
            return "\u96f6";
        }
        if (amount < 20L && amount >= 10L) {
            String chinese = this.thousandToChinese((int)amount);
            return this.colloquialMode ? chinese.substring(1) : chinese;
        }
        int[] parts = new int[4];
        int i = 0;
        while (amount != 0L) {
            parts[i] = (int)(amount % 10000L);
            amount /= 10000L;
            ++i;
        }
        StringBuilder chineseStr = new StringBuilder();
        int partValue = parts[0];
        if (partValue > 0) {
            partChinese = this.thousandToChinese(partValue);
            chineseStr.insert(0, partChinese);
            if (partValue < 1000) {
                ChineseNumberFormatter.addPreZero(chineseStr);
            }
        }
        if ((partValue = parts[1]) > 0) {
            if (partValue % 10 == 0 && parts[0] > 0) {
                ChineseNumberFormatter.addPreZero(chineseStr);
            }
            partChinese = this.thousandToChinese(partValue);
            chineseStr.insert(0, partChinese + "\u4e07");
            if (partValue < 1000) {
                ChineseNumberFormatter.addPreZero(chineseStr);
            }
        } else {
            ChineseNumberFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[2]) > 0) {
            if (partValue % 10 == 0 && parts[1] > 0) {
                ChineseNumberFormatter.addPreZero(chineseStr);
            }
            partChinese = this.thousandToChinese(partValue);
            chineseStr.insert(0, partChinese + "\u4ebf");
            if (partValue < 1000) {
                ChineseNumberFormatter.addPreZero(chineseStr);
            }
        } else {
            ChineseNumberFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            if (parts[2] == 0) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = this.thousandToChinese(partValue);
            chineseStr.insert(0, partChinese + "\u4e07");
        }
        if (StrUtil.isNotEmpty(chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    private String thousandToChinese(int amountPart) {
        if (amountPart == 0) {
            return String.valueOf(DIGITS[0]);
        }
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                boolean isUseTraditional = this.useTraditional;
                chineseStr.insert(0, ChineseNumberFormatter.numberToChinese(digit, isUseTraditional) + ChineseNumberParser.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return DIGITS[0];
        }
        return DIGITS[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static void addPreZero(StringBuilder chineseStr) {
        if (StrUtil.isEmpty(chineseStr)) {
            return;
        }
        if ('\u96f6' != chineseStr.charAt(0)) {
            chineseStr.insert(0, '\u96f6');
        }
    }
}

