/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.text.StrUtil;

public class KeyManagerUtil {
    public static KeyManagerFactory getDefaultKeyManagerFactory() {
        return KeyManagerUtil.getDefaultKeyManagerFactory(null);
    }

    public static KeyManagerFactory getDefaultKeyManagerFactory(Provider provider) {
        return KeyManagerUtil.getKeyManagerFactory(null, provider);
    }

    public static KeyManagerFactory getKeyManagerFactory(String algorithm, Provider provider) {
        if (StrUtil.isBlank(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        try {
            return null == provider ? KeyManagerFactory.getInstance(algorithm) : KeyManagerFactory.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HutoolException(e);
        }
    }

    public static KeyManager[] getDefaultKeyManagers(KeyStore keyStore, char[] password) {
        return KeyManagerUtil.getKeyManagers(keyStore, password, null, null);
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, char[] password, String algorithm, Provider provider) {
        KeyManagerFactory keyManagerFactory = KeyManagerUtil.getKeyManagerFactory(algorithm, provider);
        try {
            keyManagerFactory.init(keyStore, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new HutoolException(e);
        }
        return keyManagerFactory.getKeyManagers();
    }
}

