/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;

public class PaillierKey
implements Key {
    private static final long serialVersionUID = 1L;
    public static final String ALGORITHM_NAME = "Paillier";
    private final BigInteger n;

    protected PaillierKey(BigInteger n) {
        this.n = n;
    }

    public BigInteger getN() {
        return this.n;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getFormat() {
        return "NONE";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    public BigInteger getNSquare() {
        return this.n.multiply(this.n);
    }

    public BigInteger generateRandomRinZn(SecureRandom random) {
        BigInteger r;
        int length = this.n.bitLength();
        while ((r = new BigInteger(length, 64, random)).compareTo(this.n) >= 0 || r.gcd(this.n).intValue() != 1) {
        }
        return r;
    }
}

