/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.Closeable;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.http.client.cookie.InMemoryCookieStore;
import org.dromara.hutool.http.client.engine.jdk.JdkCookieStore;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;

public class JdkCookieManager
implements Closeable {
    private CookieManager cookieManager;

    public JdkCookieManager() {
        this(new CookieManager(new JdkCookieStore(new InMemoryCookieStore()), CookiePolicy.ACCEPT_ALL));
    }

    public JdkCookieManager(CookieManager raw) {
        this.cookieManager = raw;
    }

    public boolean isEnable() {
        return null != this.cookieManager;
    }

    @Override
    public void close() {
        this.cookieManager = null;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public JdkCookieManager setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        return this;
    }

    public List<HttpCookie> getCookies(JdkHttpConnection conn) {
        if (null == this.cookieManager) {
            return null;
        }
        return this.cookieManager.getCookieStore().get(JdkCookieManager.getURI(conn));
    }

    public Map<String, List<String>> loadForRequest(JdkHttpConnection conn) {
        if (null == this.cookieManager) {
            return null;
        }
        try {
            return this.cookieManager.get(JdkCookieManager.getURI(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public JdkCookieManager saveFromResponse(JdkHttpConnection conn) {
        return this.saveFromResponse(conn, conn.headers());
    }

    public JdkCookieManager saveFromResponse(JdkHttpConnection conn, Map<String, List<String>> responseHeaders) {
        if (null == this.cookieManager || MapUtil.isEmpty(responseHeaders)) {
            return this;
        }
        try {
            this.cookieManager.put(JdkCookieManager.getURI(conn), responseHeaders);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    private static URI getURI(JdkHttpConnection conn) {
        return UrlUtil.toURI(conn.getUrl());
    }
}

