/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.action;

import java.io.File;
import java.util.List;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.http.server.HttpServerRequest;
import org.dromara.hutool.http.server.HttpServerResponse;
import org.dromara.hutool.http.server.action.Action;

public class RootAction
implements Action {
    public static final String DEFAULT_INDEX_FILE_NAME = "index.html";
    private final File rootDir;
    private final List<String> indexFileNames;

    public RootAction(String rootDir) {
        this(new File(rootDir));
    }

    public RootAction(File rootDir) {
        this(rootDir, DEFAULT_INDEX_FILE_NAME);
    }

    public RootAction(String rootDir, String ... indexFileNames) {
        this(new File(rootDir), indexFileNames);
    }

    public RootAction(File rootDir, String ... indexFileNames) {
        this.rootDir = rootDir;
        this.indexFileNames = ListUtil.of(indexFileNames);
    }

    @Override
    public void doAction(HttpServerRequest request, HttpServerResponse response) {
        String path = request.getPath();
        File file = FileUtil.file(this.rootDir, path);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String indexFileName : this.indexFileNames) {
                    if (!(file = FileUtil.file(file, indexFileName)).exists() || !file.isFile()) continue;
                    response.write(file);
                    return;
                }
            } else {
                String name = request.getParam("name");
                response.write(file, name);
                return;
            }
        }
        response.send404("404 Not Found !");
    }
}

