/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.bean.BeanDesc;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.ValueProviderToBeanCopier;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;
import org.dromara.hutool.json.support.BeanToJSONCopier;
import org.dromara.hutool.json.support.InternalJSONUtil;
import org.dromara.hutool.json.support.JSONObjectValueProvider;

public class BeanTypeAdapter
implements MatcherJSONSerializer<Object>,
MatcherJSONDeserializer<Object> {
    public static final BeanTypeAdapter INSTANCE = new BeanTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        JSON contextJson = ObjUtil.apply(context, JSONContext::getContextJson);
        BeanDesc beanDesc = BeanUtil.getBeanDesc(bean.getClass());
        if (beanDesc.isEmpty()) {
            return true;
        }
        boolean isTransparent = ObjUtil.defaultIfNull(ObjUtil.apply(contextJson, JSON::config), JSONConfig::isTransientSupport, true);
        return beanDesc.isReadable(isTransparent) && (null == contextJson || contextJson instanceof JSONObject);
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return json instanceof JSONObject && (json.isEmpty() || BeanUtil.isWritableBean(TypeUtil.getClass(deserializeType)));
    }

    @Override
    public JSON serialize(Object bean, JSONContext context) {
        BeanToJSONCopier copier = new BeanToJSONCopier(bean, context.getOrCreateObj(), context.getFactory());
        return copier.copy();
    }

    @Override
    public Object deserialize(JSON json, Type deserializeType) {
        Object target = ConstructorUtil.newInstanceIfPossible(TypeUtil.getClass(deserializeType));
        if (json.isEmpty()) {
            return target;
        }
        ValueProviderToBeanCopier copier = new ValueProviderToBeanCopier(new JSONObjectValueProvider((JSONObject)json), target, deserializeType, InternalJSONUtil.toCopyOptions(json.config()));
        return copier.copy();
    }
}

