/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.writer;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.comparator.IndexedComparator;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.TableMap;
import org.dromara.hutool.core.map.multi.RowKeyTable;
import org.dromara.hutool.core.map.multi.Table;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.excel.ExcelConfig;

public class ExcelWriteConfig
extends ExcelConfig {
    protected boolean onlyAlias;
    protected boolean insertRow = true;
    protected Comparator<String> aliasComparator;

    @Override
    public ExcelWriteConfig setHeaderAlias(Map<String, String> headerAlias) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.setHeaderAlias(headerAlias);
    }

    @Override
    public ExcelWriteConfig addHeaderAlias(String header, String alias) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.addHeaderAlias(header, alias);
    }

    @Override
    public ExcelWriteConfig removeHeaderAlias(String header) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.removeHeaderAlias(header);
    }

    public ExcelWriteConfig setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriteConfig setInsertRow(boolean insertRow) {
        this.insertRow = insertRow;
        return this;
    }

    public Comparator<String> getCachedAliasComparator() {
        Map headerAlias = this.headerAlias;
        if (MapUtil.isEmpty(headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set keySet = headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[0]));
        }
        return aliasComparator;
    }

    public Table<?, ?, ?> aliasTable(Map<?, ?> rowMap) {
        RowKeyTable filteredTable = new RowKeyTable(new LinkedHashMap(), TableMap::new);
        if (MapUtil.isEmpty(this.headerAlias)) {
            rowMap.forEach((key, value) -> filteredTable.put(key, key, value));
        } else {
            rowMap.forEach((key, value) -> {
                String aliasName = (String)this.headerAlias.get(StrUtil.toString(key));
                if (null != aliasName) {
                    filteredTable.put(key, aliasName, value);
                } else if (!this.onlyAlias) {
                    filteredTable.put(key, key, value);
                }
            });
        }
        return filteredTable;
    }
}

