/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec;

import org.dromara.hutool.core.regex.PatternPool;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;

public class Luhn {
    public static boolean check(String strWithCheckDigit) {
        if (StrUtil.isBlank(strWithCheckDigit)) {
            return false;
        }
        if (!ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)strWithCheckDigit)) {
            return false;
        }
        return Luhn.sum(strWithCheckDigit) % 10 == 0;
    }

    public static int getCheckDigit(String str, boolean withCheckDigit) {
        if (withCheckDigit) {
            str = str.substring(0, str.length() - 1);
        }
        return 10 - Luhn.sum(str + "0") % 10;
    }

    private static int sum(String str) {
        char[] strArray = str.toCharArray();
        int n = strArray.length;
        int sum = strArray[n - 1] - 48;
        for (int i = 2; i <= n; ++i) {
            int a = strArray[n - i] - 48;
            if ((i & 1) == 0) {
                a *= 2;
            }
            sum += a / 10 + a % 10;
        }
        return sum;
    }
}

