/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.NoResourceException;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL url;
    protected String name;
    private long lastModified = 0L;

    public UrlResource(URI uri) {
        this(UrlUtil.url(uri), null);
    }

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        if (null != url && "file".equals(url.getProtocol())) {
            this.lastModified = FileUtil.file(url).lastModified();
        }
        this.name = ObjUtil.defaultIfNull(name, () -> null != url ? FileNameUtil.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long size() {
        return UrlUtil.size(this.url);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (null == this.url) {
            throw new NoResourceException("Resource URL is null!");
        }
        return UrlUtil.getStream(this.url);
    }

    @Override
    public boolean isModified() {
        return 0L != this.lastModified && this.lastModified != this.getFile().lastModified();
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }

    public UrlResource createRelative(String relativePath) {
        return new UrlResource(UrlUtil.getURL(this.getUrl(), relativePath));
    }
}

