/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.event.Event;
import org.dromara.hutool.core.lang.event.EventPublisher;
import org.dromara.hutool.core.lang.event.Subscriber;
import org.dromara.hutool.core.lang.loader.LazyFunLoader;
import org.dromara.hutool.core.lang.loader.Loader;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class SimpleEventPublisher
implements EventPublisher {
    private final List<Subscriber> subscribers;
    private Loader<ExecutorService> executorServiceLoader;

    public static SimpleEventPublisher of() {
        return SimpleEventPublisher.of(null);
    }

    public static SimpleEventPublisher of(List<Subscriber> subscribers) {
        return new SimpleEventPublisher(subscribers, null);
    }

    public SimpleEventPublisher(List<Subscriber> subscribers, Loader<ExecutorService> executorServiceLoader) {
        this.subscribers = ObjUtil.defaultIfNull(subscribers, ArrayList::new);
        this.executorServiceLoader = ObjUtil.defaultIfNull(executorServiceLoader, LazyFunLoader.of(ThreadUtil::newExecutor));
    }

    public SimpleEventPublisher setExecutorService(ExecutorService executorService) {
        this.executorServiceLoader = () -> Assert.notNull(executorService);
        return this;
    }

    @Override
    public EventPublisher register(Subscriber subscriber) {
        this.subscribers.add(subscriber);
        Collections.sort(this.subscribers);
        return this;
    }

    @Override
    public void publish(Event event) {
        for (Subscriber subscriber : this.subscribers) {
            if (subscriber.async()) {
                this.executorServiceLoader.get().submit(() -> subscriber.update(event));
                continue;
            }
            subscriber.update(event);
        }
    }
}

