/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.lang.Assert;

public class JdkProxyUtil {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";

    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return JdkProxyUtil.newProxyInstance(ClassLoaderUtil.getClassLoader(), invocationHandler, interfaces);
    }

    public static boolean isProxy(Object object) {
        Assert.notNull(object);
        return JdkProxyUtil.isProxyClass(object.getClass());
    }

    public static boolean isJdkProxy(Object object) {
        Assert.notNull(object);
        return JdkProxyUtil.isJdkProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        Assert.notNull(object);
        return JdkProxyUtil.isCglibProxyClass(object.getClass());
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return JdkProxyUtil.isJdkProxyClass(clazz) || JdkProxyUtil.isCglibProxyClass(clazz);
    }

    public static boolean isJdkProxyClass(Class<?> clazz) {
        return Proxy.isProxyClass(Assert.notNull(clazz));
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return Assert.notNull(clazz).getName().contains(CGLIB_CLASS_SEPARATOR);
    }
}

