/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.core.date.Week;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.cron.CronException;

public enum Part {
    SECOND(13, 0, 59),
    MINUTE(12, 0, 59),
    HOUR(11, 0, 23),
    DAY_OF_MONTH(5, 1, 31),
    MONTH(2, Month.JANUARY.getValueBaseOne(), Month.DECEMBER.getValueBaseOne()),
    DAY_OF_WEEK(7, Week.SUNDAY.ordinal(), Week.SATURDAY.ordinal()),
    YEAR(1, 1970, 2099);

    private static final Part[] ENUMS;
    private final int calendarField;
    private final int min;
    private final int max;

    private Part(int calendarField, int min, int max) {
        this.calendarField = calendarField;
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int checkValue(int value) throws CronException {
        Assert.checkBetween(value, this.min, this.max, () -> new CronException("{} value {} out of range: [{} , {}]", this.name(), value, this.min, this.max));
        return value;
    }

    public static Part of(int i) {
        return ENUMS[i];
    }

    static {
        ENUMS = Part.values();
    }
}

