/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.timingwheel;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.dromara.hutool.cron.timingwheel.TimerTask;

public class TimerTaskList
implements Delayed {
    private final AtomicLong expire = new AtomicLong(-1L);
    private final TimerTask root;

    public TimerTaskList() {
        this.root.prev = this.root = new TimerTask(null, -1L);
        this.root.next = this.root;
    }

    public boolean setExpiration(long expire) {
        return this.expire.getAndSet(expire) != expire;
    }

    public long getExpire() {
        return this.expire.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(TimerTask timerTask) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (timerTask.timerTaskList == null) {
                timerTask.timerTaskList = this;
                TimerTask tail = this.root.prev;
                timerTask.next = this.root;
                timerTask.prev = tail;
                tail.next = timerTask;
                this.root.prev = timerTask;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(TimerTask timerTask) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (this.equals(timerTask.timerTaskList)) {
                timerTask.next.prev = timerTask.prev;
                timerTask.prev.next = timerTask.next;
                timerTask.timerTaskList = null;
                timerTask.next = null;
                timerTask.prev = null;
            }
        }
    }

    public synchronized void flush(Consumer<TimerTask> flush) {
        TimerTask timerTask = this.root.next;
        while (!timerTask.equals(this.root)) {
            this.removeTask(timerTask);
            flush.accept(timerTask);
            timerTask = this.root.next;
        }
        this.expire.set(-1L);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return Math.max(0L, unit.convert(this.expire.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof TimerTaskList) {
            return Long.compare(this.expire.get(), ((TimerTaskList)o).expire.get());
        }
        return 0;
    }
}

