/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.crypto.Cipher;
import org.dromara.hutool.crypto.CipherMode;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.SecureUtil;

public class JceCipher
extends SimpleWrapper<javax.crypto.Cipher>
implements Cipher {
    public JceCipher(String algorithm) {
        this(SecureUtil.createCipher(algorithm));
    }

    public JceCipher(javax.crypto.Cipher cipher) {
        super(Assert.notNull(cipher));
    }

    @Override
    public String getAlgorithmName() {
        return ((javax.crypto.Cipher)this.raw).getAlgorithm();
    }

    @Override
    public int getBlockSize() {
        return ((javax.crypto.Cipher)this.raw).getBlockSize();
    }

    @Override
    public int getOutputSize(int len) {
        return ((javax.crypto.Cipher)this.raw).getOutputSize(len);
    }

    public byte[] getIV() {
        return ((javax.crypto.Cipher)this.raw).getIV();
    }

    @Override
    public void init(CipherMode mode, Cipher.Parameters parameters) {
        Assert.isInstanceOf(JceParameters.class, parameters, "Only support JceParameters!", new Object[0]);
        try {
            this.init(mode.getValue(), (JceParameters)parameters);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public void init(int mode, JceParameters jceParameters) throws InvalidAlgorithmParameterException, InvalidKeyException {
        javax.crypto.Cipher cipher = (javax.crypto.Cipher)this.raw;
        if (null != jceParameters.parameterSpec) {
            if (null != jceParameters.random) {
                cipher.init(mode, jceParameters.key, jceParameters.parameterSpec, jceParameters.random);
            } else {
                cipher.init(mode, jceParameters.key, jceParameters.parameterSpec);
            }
        } else if (null != jceParameters.random) {
            cipher.init(mode, jceParameters.key, jceParameters.random);
        } else {
            cipher.init(mode, jceParameters.key);
        }
    }

    public byte[] process(byte[] in, int inOff, int len) {
        return ((javax.crypto.Cipher)this.raw).update(in, inOff, len);
    }

    public int process(byte[] in, int inOff, int len, byte[] out) {
        try {
            return ((javax.crypto.Cipher)this.raw).update(in, inOff, len, out);
        }
        catch (ShortBufferException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public int process(byte[] in, int inOff, int len, byte[] out, int outOff) {
        try {
            return ((javax.crypto.Cipher)this.raw).update(in, inOff, len, out, outOff);
        }
        catch (ShortBufferException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        try {
            return ((javax.crypto.Cipher)this.raw).doFinal(out, outOff);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] processFinal(byte[] in) {
        try {
            return ((javax.crypto.Cipher)this.raw).doFinal(in);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] processFinal(byte[] data, int inOffset, int inputLen) {
        try {
            return ((javax.crypto.Cipher)this.raw).doFinal(data, inOffset, inputLen);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static class JceParameters
    implements Cipher.Parameters {
        private final Key key;
        private final AlgorithmParameterSpec parameterSpec;
        private final SecureRandom random;

        public JceParameters(Key key, AlgorithmParameterSpec parameterSpec, SecureRandom random) {
            this.key = key;
            this.parameterSpec = parameterSpec;
            this.random = random;
        }
    }
}

