/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest.otp;

import java.time.Duration;
import java.time.Instant;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.digest.mac.HmacAlgorithm;
import org.dromara.hutool.crypto.digest.otp.HOTP;

public class TOTP
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    public TOTP(byte[] key) {
        this(DEFAULT_TIME_STEP, key);
    }

    public TOTP(Duration timeStep, byte[] key) {
        this(timeStep, 6, key);
    }

    public TOTP(Duration timeStep, int passwordLength, byte[] key) {
        this(timeStep, passwordLength, HOTP_HMAC_ALGORITHM, key);
    }

    public TOTP(Duration timeStep, int passwordLength, HmacAlgorithm algorithm, byte[] key) {
        super(passwordLength, algorithm, key);
        this.timeStep = timeStep;
    }

    public int generate(Instant timestamp) {
        return this.generate(timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public boolean validate(Instant timestamp, int offsetSize, int code) {
        if (offsetSize == 0) {
            return this.generate(timestamp) == code;
        }
        for (int i = -offsetSize; i <= offsetSize; ++i) {
            if (this.generate(timestamp.plus(this.getTimeStep().multipliedBy(i))) != code) continue;
            return true;
        }
        return false;
    }

    public static String generateGoogleSecretKey(String account, int numBytes) {
        return StrUtil.format("otpauth://totp/{}?secret={}", account, TOTP.generateSecretKey(numBytes));
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

